/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.password;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;
import uk.ac.warwick.util.cache.Cache;
import uk.ac.warwick.util.cache.CacheEntryFactory;
import uk.ac.warwick.util.cache.CacheEntryUpdateException;
import uk.ac.warwick.util.cache.Caches;
import uk.ac.warwick.util.cache.SingularCacheEntryFactory;
import uk.ac.warwick.util.collections.Pair;
import uk.ac.warwick.util.httpclient.httpclient4.HttpMethodExecutor;
import uk.ac.warwick.util.httpclient.httpclient4.SimpleHttpMethodExecutor;
import uk.ac.warwick.util.password.PwnedPasswordService;

@Service
public class PwnedPasswordServiceImpl
extends SingularCacheEntryFactory<String, ArrayList<Pair<String, Integer>>>
implements PwnedPasswordService,
CacheEntryFactory<String, ArrayList<Pair<String, Integer>>> {
    private static final int PASSWORD_PREFIX_LENGTH = 6;
    private static final int MAXIMUM_CACHE_SIZE = 10000;
    private final String apiBaseUrl;
    private Cache<String, ArrayList<Pair<String, Integer>>> cache;

    public PwnedPasswordServiceImpl(String apiBaseUrl, String cacheStrategy) {
        this.apiBaseUrl = apiBaseUrl;
        this.cache = Caches.builder((String)"PwnedPasswords", (CacheEntryFactory)this, (Caches.CacheStrategy)Caches.CacheStrategy.valueOf((String)cacheStrategy)).maximumSize(10000L).expireAfterWrite(Duration.ofDays(1L)).build();
    }

    @Override
    public int numMatches(String passwordHash) throws IOException, IllegalArgumentException {
        ArrayList searchResult;
        if (passwordHash.length() < 6) {
            throw new IllegalArgumentException("password hash must have length >= 7");
        }
        String prefix = passwordHash.substring(0, 5);
        String suffix = passwordHash.substring(5);
        try {
            searchResult = (ArrayList)this.cache.get((Serializable)((Object)prefix));
        }
        catch (CacheEntryUpdateException e) {
            throw new IOException(e);
        }
        return this.countHashMatches(searchResult, suffix);
    }

    private int countHashMatches(ArrayList<Pair<String, Integer>> matchedSuffixes, String passwordSuffix) {
        for (Pair<String, Integer> suffixAndCount : matchedSuffixes) {
            if (!passwordSuffix.equals(suffixAndCount.getLeft())) continue;
            return (Integer)suffixAndCount.getRight();
        }
        return 0;
    }

    private ArrayList<Pair<String, Integer>> rangeSearch(String passwordHashPrefix) throws IOException {
        String url = this.apiBaseUrl + "/" + passwordHashPrefix;
        return new ArrayList<Pair<String, Integer>>((Collection)new SimpleHttpMethodExecutor(HttpMethodExecutor.Method.get, url).execute(response -> {
            if (response.getStatusLine().getStatusCode() > 200) {
                throw new IOException("Response from 'haveibeenpwned' api had status: " + response.getStatusLine().getStatusCode() + ", reason: " + response.getStatusLine().getReasonPhrase());
            }
            String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            BufferedReader reader = new BufferedReader(new StringReader(body));
            return reader.lines().map(line -> {
                String[] splitLine = line.split(":");
                if (splitLine.length == 2) {
                    return Pair.of((Object)splitLine[0].trim(), (Object)Integer.parseInt(splitLine[1].trim()));
                }
                return null;
            }).collect(Collectors.toList());
        }).getRight());
    }

    public ArrayList<Pair<String, Integer>> create(String key) throws CacheEntryUpdateException {
        try {
            return this.rangeSearch(key);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new CacheEntryUpdateException((Throwable)e);
        }
    }

    public boolean shouldBeCached(ArrayList<Pair<String, Integer>> val) {
        return true;
    }
}

