package uk.ac.warwick.util.password;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Locale;

public class PwnedPasswordUtil {

    private PwnedPasswordUtil() {
        // utility class
    }

    public static String getHumanError(int breachScore) {
        String times = DecimalFormat.getNumberInstance(Locale.ENGLISH).format(breachScore) + (breachScore == 1 ? " time" : " times");
        return "The password you're trying to set is a known, commonly-used password. It has been used at least " + times + " in public security leaks.";
    }

    public static int getBreachScoreForPassword(PwnedPasswordService service, String password) throws IOException, IllegalArgumentException {
        return service.numMatches(HashUtils.generateSHA1Hash(password).toUpperCase());
    }

    public static String getHashForPassword(String password) {
        return HashUtils.generateSHA1Hash(password).toUpperCase();
    }
}
