package uk.ac.warwick.util.password;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashUtils {

    private HashUtils() {}

    public static String generateMD5Hash(String input) throws IllegalStateException {
        MessageDigest algorithm;
        try {
            algorithm = MessageDigest.getInstance("MD5");
        } catch (final NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        return digestAndHex(algorithm, input);
    }

    public static String generateSHA1Hash(String input) throws IllegalStateException {

        MessageDigest algorithm;
        try {
            algorithm = MessageDigest.getInstance("SHA-1");
        } catch (final NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        return digestAndHex(algorithm, input);
    }

    private static String digestAndHex(MessageDigest algorithm, String input) {
        byte[] hashInBytes = algorithm.digest(input.getBytes(StandardCharsets.UTF_8));

        StringBuilder sb = new StringBuilder();
        for (byte b : hashInBytes) {
            sb.append(String.format("%02x", b));
        }

        return sb.toString();
    }

}
