/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.nio.client.HttpAsyncClient;
import uk.ac.warwick.util.mywarwick.HttpClient;
import uk.ac.warwick.util.mywarwick.model.Configuration;

@Named
@Singleton
public class HttpClientImpl
implements HttpClient {
    private final CloseableHttpAsyncClient httpClient;

    @Inject
    public HttpClientImpl(Configuration config) {
        this.httpClient = HttpAsyncClients.custom().setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(8192).setCharset(StandardCharsets.UTF_8).build()).setDefaultRequestConfig(this.getRequestConfig()).setMaxConnPerRoute(config.getHttpMaxConnPerRoute()).setMaxConnTotal(config.getHttpMaxConn()).build();
        this.start();
    }

    @Override
    public void start() {
        this.httpClient.start();
    }

    @Override
    @PreDestroy
    public void destroy() throws Exception {
        this.httpClient.close();
    }

    @Override
    public boolean isRunning() {
        return this.httpClient.isRunning();
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        return this.httpClient.execute(request, callback);
    }

    @Override
    public RequestConfig getRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(2000).setSocketTimeout(2000).setExpectContinueEnabled(true).setRedirectsEnabled(false).build();
    }

    public HttpAsyncClient get() {
        return this.httpClient;
    }
}

