/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick.model.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.mywarwick.model.request.Activity;
import uk.ac.warwick.util.mywarwick.model.request.Recipients;
import uk.ac.warwick.util.mywarwick.model.request.Tag;

public class ActivityTest {
    ObjectMapper objectMapper = new ObjectMapper();
    private final String expectedRequestJsonString = "{\"type\":\"faketype\",\"title\":\"faketitle\",\"text\":\"faketext\",\"url\":\"fakeurl\",\"tags\":[{\"name\":\"fakename\",\"value\":\"fakevalue\",\"display_value\":\"fakedv\"}],\"recipients\":{\"users\":[\"u1234567\"],\"groups\":[\"ch-students\"]},\"send_email\":null}";

    @Test
    public void shouldMakeCorrectJsonAgainAPISpec() throws JsonProcessingException {
        HashSet<String> userIds = new HashSet<String>();
        HashSet<String> groups = new HashSet<String>();
        userIds.add("u1234567");
        groups.add("ch-students");
        Activity activity = new Activity(userIds, groups, "faketitle", "fakeurl", "faketext", "faketype");
        Tag tag = new Tag();
        tag.setDisplay_value("fakedv");
        tag.setValue("fakevalue");
        tag.setName("fakename");
        activity.setTags(tag);
        Assert.assertEquals((Object)"{\"type\":\"faketype\",\"title\":\"faketitle\",\"text\":\"faketext\",\"url\":\"fakeurl\",\"tags\":[{\"name\":\"fakename\",\"value\":\"fakevalue\",\"display_value\":\"fakedv\"}],\"recipients\":{\"users\":[\"u1234567\"],\"groups\":[\"ch-students\"]},\"send_email\":null}", (Object)this.objectMapper.writeValueAsString((Object)activity));
    }

    @Test
    public void shouldIdentifyInvalidTag() {
        Assert.assertFalse((boolean)new Tag().isValid());
        Tag tag = new Tag();
        tag.setName("");
        tag.setValue("");
        Assert.assertFalse((boolean)tag.isValid());
    }

    @Test
    public void shouldIdentifyValidTag() {
        Tag tag = new Tag();
        tag.setName("ok");
        tag.setValue("computer");
        Assert.assertTrue((boolean)tag.isValid());
    }

    @Test
    public void shouldIdentifyInvalidRecipients() {
        Recipients recipients = new Recipients();
        Assert.assertFalse((boolean)recipients.isValid());
        recipients.setUsers(new HashSet());
        Assert.assertFalse((boolean)recipients.isValid());
    }

    @Test
    public void shouldIdentifyValidRecipients() {
        Recipients recipients = new Recipients();
        HashSet<String> users = new HashSet<String>();
        users.add("user1");
        recipients.setUsers(users);
        Assert.assertTrue((boolean)recipients.isValid());
        HashSet<String> group = new HashSet<String>();
        group.add("in-its");
        recipients.setGroups(group);
        Assert.assertTrue((boolean)recipients.isValid());
    }

    @Test
    public void shouldIdentifyValidActivity() {
        Activity activity0 = new Activity("userId", "title", "url", "text", "type");
        Assert.assertTrue((boolean)activity0.isValid());
        Activity activity1 = new Activity("userId", "title", null, null, "type");
        Assert.assertTrue((boolean)activity1.isValid());
        HashSet<String> userIds = new HashSet<String>();
        userIds.add("user1");
        Activity activity2 = new Activity(userIds, "title", null, null, "type");
        Assert.assertTrue((boolean)activity2.isValid());
        HashSet groupIds = new HashSet();
        userIds.add("user1");
        Activity activity3 = new Activity(userIds, groupIds, "title", null, null, "type");
        Assert.assertTrue((boolean)activity3.isValid());
        Activity activity4 = new Activity();
        activity4.setRecipients(new Recipients("userA"));
        activity4.setTitle("title");
        activity4.setType("type");
        Assert.assertTrue((boolean)activity4.isValid());
    }

    @Test
    public void shouldIdentifyInvalidActivity() {
        Activity activity0 = new Activity();
        Assert.assertFalse((boolean)activity0.isValid());
        Activity activity1 = new Activity("userId", "title", null, null, "type");
        HashSet<Tag> tags = new HashSet<Tag>();
        Tag tag = new Tag();
        tag.setName("");
        tag.setValue("");
        tags.add(tag);
        activity1.setTags(tags);
        Assert.assertFalse((boolean)activity1.isValid());
        Activity activity2 = new Activity("userId", "title", null, null, "type");
        Recipients invalidRecipients = new Recipients();
        activity2.setRecipients(invalidRecipients);
        Assert.assertFalse((boolean)activity2.isValid());
    }
}

