/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import uk.ac.warwick.util.mywarwick.HttpClient;
import uk.ac.warwick.util.mywarwick.MyWarwickServiceImpl;
import uk.ac.warwick.util.mywarwick.model.Configuration;
import uk.ac.warwick.util.mywarwick.model.Instance;
import uk.ac.warwick.util.mywarwick.model.request.Activity;

@RunWith(value=MockitoJUnitRunner.class)
public class MyWarwickServiceImplSingleInstanceTest {
    @Mock
    Configuration configuration;
    Instance instance = new Instance("https://fake.com", "fakeProviderId", "shylock-mywarwick-api-user", "blinking", "true");
    Activity activity = new Activity("id", "title", "url", "text", "fake-type");
    @Mock
    HttpClient httpClient;
    private MyWarwickServiceImpl myWarwickService;

    @Before
    public void setup() {
        HashSet<Instance> instanceList = new HashSet<Instance>();
        instanceList.add(this.instance);
        Mockito.when((Object)this.configuration.getInstances()).thenReturn(instanceList);
        this.myWarwickService = new MyWarwickServiceImpl(this.httpClient, this.configuration);
    }

    @Test
    public void httpClientShouldNotBeNull() {
        assert (this.myWarwickService.getHttpClient() != null);
    }

    @Test
    public void activityPathShouldBeCorrect() {
        Assert.assertEquals((Object)"https://fake.com/api/streams/fakeProviderId/activities", (Object)((Instance)this.myWarwickService.getInstances().stream().collect(Collectors.toList()).get(0)).getActivityPath());
    }

    @Test
    public void notificationPathShouldBeCorrect() {
        Assert.assertEquals((Object)"https://fake.com/api/streams/fakeProviderId/notifications", (Object)((Instance)this.myWarwickService.getInstances().stream().collect(Collectors.toList()).get(0)).getNotificationPath());
    }

    @Test
    public void shouldCreateJsonBodyCorrectly() throws JsonProcessingException {
        Assert.assertEquals((Object)new ObjectMapper().writeValueAsString((Object)this.activity), (Object)this.myWarwickService.makeJsonBody(this.activity));
    }

    @Test
    public void requestShouldSerializeSendEmailCorrectly() throws IOException {
        Activity nullSendEmail = this.activity;
        JsonNode nullSendEmailJson = new ObjectMapper().readTree(this.myWarwickService.makeJsonBody(nullSendEmail));
        Assert.assertTrue((boolean)nullSendEmailJson.path("send_email").isNull());
        Activity falseSendEmail = new Activity("id", "title", "url", "text", "fake-type");
        falseSendEmail.setSendEmail(Boolean.valueOf(false));
        JsonNode falseSendEmailJson = new ObjectMapper().readTree(this.myWarwickService.makeJsonBody(falseSendEmail));
        Assert.assertTrue((boolean)falseSendEmailJson.path("send_email").isBoolean());
        Assert.assertFalse((boolean)falseSendEmailJson.path("send_email").asBoolean());
        Activity trueSendEmail = new Activity("id", "title", "url", "text", "fake-type");
        trueSendEmail.setSendEmail(Boolean.valueOf(true));
        JsonNode trueSendEmailJson = new ObjectMapper().readTree(this.myWarwickService.makeJsonBody(trueSendEmail));
        Assert.assertTrue((boolean)trueSendEmailJson.path("send_email").isBoolean());
        Assert.assertTrue((boolean)trueSendEmailJson.path("send_email").asBoolean());
    }

    @Test
    public void requestShouldHaveCorrectJsonBody() throws IOException {
        String expected = "{\"type\":\"fake-type\",\"title\":\"title\",\"url\":\"url\",\"tags\":[]\"recipients\":{\"users\":[\"id\"]},\"text\":\"text\"}";
        Assert.assertEquals((Object)expected, (Object)IOUtils.toString((InputStream)this.myWarwickService.makeRequest("", expected, "", "", "").getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void requestShouldHaveCorrectPath() throws MalformedURLException {
        String expected = "http://test.com";
        Assert.assertEquals((Object)expected, (Object)this.myWarwickService.makeRequest(expected, "", "", "", "").getURI().toURL().toString());
    }

    @Test
    public void requestShouldHaveCorrectAuthHeader() {
        Assert.assertEquals((Object)"Basic c2h5bG9jay1teXdhcndpY2stYXBpLXVzZXI6Ymxpbmtpbmc=", (Object)this.myWarwickService.makeRequest("", this.myWarwickService.makeJsonBody(this.activity), this.instance.getApiUser(), this.instance.getApiPassword(), "").getFirstHeader("Authorization").getValue());
    }
}

