/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import uk.ac.warwick.util.mywarwick.HttpClient;
import uk.ac.warwick.util.mywarwick.MyWarwickServiceImpl;
import uk.ac.warwick.util.mywarwick.model.Configuration;
import uk.ac.warwick.util.mywarwick.model.Instance;
import uk.ac.warwick.util.mywarwick.model.request.Activity;

@RunWith(value=MockitoJUnitRunner.class)
public class MyWarwickServiceImplMultiInstanceTest {
    private String instance1BaseUrl = "https://fake.com";
    private String instance2BaseUrl = "https://ekaf.com";
    private Instance instance1 = new Instance(this.instance1BaseUrl, "fakeProviderId", "shylock-mywarwick-api-user", "blinking", "true");
    private Instance instance2 = new Instance(this.instance2BaseUrl, "fakerProviderId", "moonwalker-api-user", "hanging", "false");
    private Activity activity = new Activity("id", "title", "url", "text", "fake-type");
    private Set<Instance> instanceList = new HashSet<Instance>();
    @Mock
    private HttpClient httpClient;
    @Mock
    private Configuration configuration;
    private MyWarwickServiceImpl myWarwickService;

    @Before
    public void setUp() {
        this.instanceList.add(this.instance1);
        this.instanceList.add(this.instance2);
        Mockito.when((Object)this.configuration.getInstances()).thenReturn(this.instanceList);
        this.myWarwickService = new MyWarwickServiceImpl(this.httpClient, this.configuration);
        Mockito.when((Object)this.httpClient.isRunning()).thenReturn((Object)true);
    }

    private Instance getInstance1FromService() {
        return this.myWarwickService.getInstances().stream().filter(i -> i.getBaseUrl().equals(this.instance1BaseUrl)).findFirst().orElseGet(null);
    }

    private Instance getInstance2FromService() {
        return this.myWarwickService.getInstances().stream().filter(i -> i.getBaseUrl().equals(this.instance2BaseUrl)).findFirst().orElseGet(null);
    }

    private Instance getInstance1FromConfig() {
        return this.configuration.getInstances().stream().filter(i -> i.getBaseUrl().equals(this.instance1BaseUrl)).findFirst().orElseGet(null);
    }

    private Instance getInstance2FromConfig() {
        return this.configuration.getInstances().stream().filter(i -> i.getBaseUrl().equals(this.instance2BaseUrl)).findFirst().orElseGet(null);
    }

    @Test
    public void activityPathShouldBeCorrectForConfig1() {
        Assert.assertEquals((Object)"https://fake.com/api/streams/fakeProviderId/activities", (Object)this.getInstance1FromService().getActivityPath());
    }

    @Test
    public void notificationPathShouldBeCorrectForConfig1() {
        Assert.assertEquals((Object)"https://fake.com/api/streams/fakeProviderId/notifications", (Object)this.getInstance1FromService().getNotificationPath());
    }

    @Test
    public void requestShouldHaveCorrectAuthHeaderForConfig1() {
        Assert.assertEquals((Object)"Basic c2h5bG9jay1teXdhcndpY2stYXBpLXVzZXI6Ymxpbmtpbmc=", (Object)this.myWarwickService.makeRequest("", this.myWarwickService.makeJsonBody(this.activity), this.getInstance1FromConfig().getApiUser(), this.getInstance1FromConfig().getApiPassword(), "").getFirstHeader("Authorization").getValue());
    }

    @Test
    public void requestShouldHaveCorrectContentTypeForConfig1() {
        Assert.assertEquals((Object)"application/json", (Object)this.myWarwickService.makeRequest("", this.myWarwickService.makeJsonBody(this.activity), this.getInstance1FromConfig().getApiUser(), this.getInstance1FromConfig().getApiPassword(), "").getFirstHeader("content-type").getValue());
    }

    @Test
    public void activityPathShouldBeCorrectForConfig2() {
        Assert.assertEquals((Object)"https://ekaf.com/api/streams/fakerProviderId/activities", (Object)this.getInstance2FromService().getActivityPath());
    }

    @Test
    public void notificationPathShouldBeCorrectForConfig2() {
        Assert.assertEquals((Object)"https://ekaf.com/api/streams/fakerProviderId/notifications", (Object)this.getInstance2FromService().getNotificationPath());
    }

    @Test
    public void requestShouldHaveCorrectAuthHeaderForConfig2() {
        Assert.assertEquals((Object)"Basic bW9vbndhbGtlci1hcGktdXNlcjpoYW5naW5n", (Object)this.myWarwickService.makeRequest("", this.myWarwickService.makeJsonBody(this.activity), this.getInstance2FromConfig().getApiUser(), this.getInstance2FromConfig().getApiPassword(), "").getFirstHeader("Authorization").getValue());
    }

    @Test
    public void requestShouldHaveCorrectContentTypeForConfig2() {
        Assert.assertEquals((Object)"application/json", (Object)this.myWarwickService.makeRequest("", this.myWarwickService.makeJsonBody(this.activity), this.getInstance2FromConfig().getApiUser(), this.getInstance2FromConfig().getApiPassword(), "").getFirstHeader("content-type").getValue());
    }

    @Test
    public void logErrorsShouldBeCorrectForConfig1() {
        Assert.assertEquals((Object)true, (Object)this.getInstance1FromService().isLogErrors());
    }

    @Test
    public void logErrorsShouldBeCorrectForConfig2() {
        Assert.assertEquals((Object)false, (Object)this.getInstance2FromService().isLogErrors());
    }
}

