/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import akka.actor.ActorSystem;
import akka.testkit.javadsl.TestKit;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.quartz.Scheduler;
import org.quartz.impl.StdScheduler;
import play.api.Configuration;
import uk.ac.warwick.userlookup.GroupService;
import uk.ac.warwick.userlookup.UserLookupInterface;
import uk.ac.warwick.util.mywarwick.FakeGroupService;
import uk.ac.warwick.util.mywarwick.FakeUserLookupService;
import uk.ac.warwick.util.mywarwick.MyWarwickModule;

public class MyWarwickModuleTest {
    static ActorSystem system;

    @BeforeClass
    public static void createActorSystem() {
        system = ActorSystem.create();
    }

    @AfterClass
    public static void tearDownActorSystem() {
        TestKit.shutdownActorSystem((ActorSystem)system);
        system = null;
    }

    @Test
    public void noConflicts() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestModule(), new MyWarwickModule()});
    }

    @Test
    public void conflicts() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new EmptyConfigModule(), new TestModule(), new MyWarwickModule()});
    }

    public static class EmptyConfigModule
    extends AbstractModule {
        protected void configure() {
        }

        @Provides
        public Config newConfig() {
            return ConfigFactory.empty();
        }
    }

    public static class TestModule
    extends AbstractModule {
        protected void configure() {
            this.bind(Configuration.class).toInstance((Object)Configuration.apply((Config)ConfigFactory.empty()));
            this.bind(GroupService.class).toInstance((Object)new FakeGroupService());
            this.bind(UserLookupInterface.class).toInstance((Object)new FakeUserLookupService());
            this.bind(Scheduler.class).toInstance((Object)new StdScheduler(null));
            this.bind(ActorSystem.class).toInstance((Object)system);
        }
    }
}

