/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import uk.ac.warwick.util.mywarwick.MyWarwickHttpResponseCallback;
import uk.ac.warwick.util.mywarwick.MyWarwickHttpResponseCallbackHelper;
import uk.ac.warwick.util.mywarwick.model.Instance;
import uk.ac.warwick.util.mywarwick.model.response.Data;
import uk.ac.warwick.util.mywarwick.model.response.Error;
import uk.ac.warwick.util.mywarwick.model.response.Response;
import uk.ac.warwick.util.mywarwick.model.response.Warning;

@RunWith(value=MockitoJUnitRunner.class)
public class MyWarwickHttpResponseCallbackTest {
    private Instance myWarwickInstance = new Instance("", "", "", "", "true");
    private Instance myWarwickInstanceNoLogErrors = new Instance("", "", "", "", "false");
    private CompletableFuture<Response> completableFuture;
    @Mock
    StatusLine fakeStatusLine;
    @Mock
    HttpResponse fakeHttpResponse;
    @Mock
    Logger fakeLogger;

    @Before
    public void setUp() {
        Mockito.when((Object)this.fakeStatusLine.getStatusCode()).thenReturn((Object)200);
        this.completableFuture = new CompletableFuture();
        Mockito.when((Object)this.fakeHttpResponse.getStatusLine()).thenReturn((Object)this.fakeStatusLine);
    }

    @After
    public void tearDown() {
        this.completableFuture = null;
    }

    @Test
    public void shouldHandleCompletedFullySuccessfulResponse() throws ExecutionException, InterruptedException {
        MyWarwickHttpResponseCallback myWarwickHttpResponseCallback = new MyWarwickHttpResponseCallback("https://test.invalid/path", "{}", this.myWarwickInstance, this.fakeLogger, this.completableFuture, (MyWarwickHttpResponseCallbackHelper)new AlwaysSuccessResponse());
        myWarwickHttpResponseCallback.completed(this.fakeHttpResponse);
        Assert.assertTrue((boolean)this.completableFuture.isDone());
        this.completableFuture.get();
    }

    @Test
    public void shouldHandleCompletedSuccessfulWithWarningResponse() {
        MyWarwickHttpResponseCallback myWarwickHttpResponseCallback = new MyWarwickHttpResponseCallback("https://test.invalid/path", "{}", this.myWarwickInstance, this.fakeLogger, this.completableFuture, (MyWarwickHttpResponseCallbackHelper)new AlwaysSuccessWithWarningResponse());
        myWarwickHttpResponseCallback.completed(this.fakeHttpResponse);
        Assert.assertTrue((boolean)this.completableFuture.isDone());
    }

    @Test
    public void shouldHandleCompletedWithErrorsResponse() throws ExecutionException, InterruptedException {
        MyWarwickHttpResponseCallback myWarwickHttpResponseCallback = new MyWarwickHttpResponseCallback("https://test.invalid/path", "{}", this.myWarwickInstance, this.fakeLogger, this.completableFuture, (MyWarwickHttpResponseCallbackHelper)new AlwaysErrorResponse());
        myWarwickHttpResponseCallback.completed(this.fakeHttpResponse);
        Assert.assertTrue((boolean)this.completableFuture.isDone());
        Assert.assertFalse((boolean)this.completableFuture.get().getErrors().isEmpty());
    }

    @Test
    public void shouldNotLogOrReturnErrors() throws ExecutionException, InterruptedException {
        MyWarwickHttpResponseCallback myWarwickHttpResponseCallback = new MyWarwickHttpResponseCallback("https://test.invalid/path", "{}", this.myWarwickInstanceNoLogErrors, this.fakeLogger, this.completableFuture, (MyWarwickHttpResponseCallbackHelper)new AlwaysErrorResponse());
        ((Logger)Mockito.verify((Object)this.fakeLogger, (VerificationMode)Mockito.never())).error(Mockito.anyString(), (Throwable)Mockito.any(Exception.class));
        ((Logger)Mockito.verify((Object)this.fakeLogger, (VerificationMode)Mockito.never())).error(Mockito.anyString());
        myWarwickHttpResponseCallback.completed(this.fakeHttpResponse);
        Assert.assertTrue((boolean)this.completableFuture.isDone());
        Assert.assertTrue((boolean)this.completableFuture.get().getErrors().isEmpty());
    }

    class AlwaysErrorResponse
    implements MyWarwickHttpResponseCallbackHelper {
        AlwaysErrorResponse() {
        }

        public Response parseHttpResponseToResponseObject(HttpResponse httpResponse, ObjectMapper mapper) {
            Response response = new Response();
            response.setSuccess(Boolean.valueOf(false));
            response.setError(new Error("999", "this is totally wrong"));
            return response;
        }
    }

    class AlwaysSuccessWithWarningResponse
    extends AlwaysSuccessResponse {
        AlwaysSuccessWithWarningResponse() {
        }

        @Override
        public Response parseHttpResponseToResponseObject(HttpResponse httpResponse, ObjectMapper mapper) throws IOException {
            Response response = super.parseHttpResponseToResponseObject(httpResponse, mapper);
            response.setWarnings(Collections.singletonList(new Warning("InvalidUsercodeAudience", "The request contains one or more invalid usercode: List()")));
            return response;
        }
    }

    class AlwaysSuccessResponse
    implements MyWarwickHttpResponseCallbackHelper {
        AlwaysSuccessResponse() {
        }

        public Response parseHttpResponseToResponseObject(HttpResponse httpResponse, ObjectMapper mapper) throws IOException {
            Response response = new Response();
            response.setSuccess(Boolean.valueOf(true));
            response.setData(new Data("123"));
            return response;
        }
    }
}

