/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import com.typesafe.config.ConfigFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.warwick.util.JettyServer;
import uk.ac.warwick.util.mywarwick.HttpClientImpl;
import uk.ac.warwick.util.mywarwick.model.Configuration;
import uk.ac.warwick.util.mywarwick.model.TypesafeConfiguration;

public class HttpClientImplTest {
    HttpClientImpl client = new HttpClientImpl((Configuration)new TypesafeConfiguration(ConfigFactory.empty()));

    @Before
    public void setup() {
        this.client.start();
    }

    @After
    public void teardown() throws Exception {
        this.client.destroy();
    }

    @Test(timeout=20000L)
    public void parallelismTimeouts() throws Exception {
        JettyServer jetty = new JettyServer();
        Map<String, String> mappings = Collections.singletonMap("/", JettyServer.SlowServlet.class.getName());
        jetty.running(mappings, () -> {
            String url = jetty.serverAddress;
            List futures = IntStream.range(0, 100).mapToObj(i -> this.client.execute((HttpUriRequest)new HttpGet(url), null)).collect(Collectors.toList());
            List responses = futures.stream().map(f -> {
                try {
                    return (HttpResponse)f.get();
                }
                catch (Exception e) {
                    Assert.fail((String)("Failed response: " + e));
                    return null;
                }
            }).collect(Collectors.toList());
            System.out.println("Got " + responses.size() + " responses");
        });
    }
}

