package uk.ac.warwick.util.mywarwick;

import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.env.MockEnvironment;
import uk.ac.warwick.util.mywarwick.model.Instance;
import uk.ac.warwick.util.mywarwick.model.SpringEnvironmentConfiguration;

import java.util.HashSet;
import java.util.Set;

import static org.junit.Assert.assertEquals;

public class SpringEnvironmentConfigurationTest {

    SpringEnvironmentConfiguration configuration;

    @Before
    public void setup() {
        MockEnvironment environment = new MockEnvironment();
        environment.setProperty("mywarwick.instances.0.baseUrl", "1");
        environment.setProperty("mywarwick.instances.0.providerId", "2");
        environment.setProperty("mywarwick.instances.0.userName", "3");
        environment.setProperty("mywarwick.instances.0.password", "4");
        environment.setProperty("mywarwick.instances.1.baseUrl", "5");
        environment.setProperty("mywarwick.instances.1.providerId", "6");
        environment.setProperty("mywarwick.instances.1.userName", "7");
        environment.setProperty("mywarwick.instances.1.password", "8");
        environment.setProperty("mywarwick.instances.1.logErrors", "false");
        configuration = new SpringEnvironmentConfiguration(environment);
    }

    @Test
    public void shouldReadPropertiesFileAndFormatToConfiguration() {
        Set<Instance> expected = new HashSet<>();
        expected.add(new Instance("1", "2", "3", "4", "true"));
        expected.add(new Instance("5", "6", "7", "8", "false"));
        assertEquals(expected, configuration.getInstances());
    }

    @Test
    public void defaults() {
        assertEquals(200, configuration.getHttpMaxConn());
    }

}