package uk.ac.warwick.util.mywarwick.healthcheck;

import akka.actor.ActorSystem;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.mywarwick.model.Configuration;

import javax.inject.Inject;
import javax.inject.Singleton;
import java.time.Duration;

@Singleton
public class PlayMyWarwickQuartzHealthcheckProvider extends AbstractMyWarwickQuartzHealthcheckProvider {

    private static final Logger LOGGER = LoggerFactory.getLogger(PlayMyWarwickQuartzHealthcheckProvider.class);

    @Inject
    public PlayMyWarwickQuartzHealthcheckProvider(Scheduler scheduler, Configuration configuration, ActorSystem system) {
        super(scheduler, configuration);

        system.scheduler().schedule(
            Duration.ofMillis(INITIAL_DELAY_MS),
            Duration.ofMillis(RUN_INTERVAL_MS),
            () -> {
                try {
                    run();
                } catch (Throwable t) {
                    LOGGER.error("Error in health check", t);
                }
            },
            system.dispatcher()
        );
    }

}
