/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick.model.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.ac.warwick.userlookup.GroupService;
import uk.ac.warwick.userlookup.UserLookupInterface;
import uk.ac.warwick.util.mywarwick.model.request.Recipients;
import uk.ac.warwick.util.mywarwick.model.request.Tag;
import uk.ac.warwick.util.mywarwick.model.request.ValidActivity;

public class Activity
implements ValidActivity {
    private String type;
    private String title;
    private String text;
    private String url;
    private Set<Tag> tags;
    private Recipients recipients;
    private Boolean sendEmail;
    private GroupService groupService;
    private UserLookupInterface userLookupInterface;

    public Activity() {
        this.recipients = new Recipients();
        this.tags = new HashSet<Tag>();
    }

    public Activity(@NotNull String userId, @NotNull String title, String url, String text, @NotNull String type) {
        this.recipients = new Recipients(userId);
        this.title = title;
        this.text = text;
        this.url = url;
        this.type = type;
    }

    public Activity(@NotNull Set<String> userIds, @NotNull String title, String url, String text, @NotNull String type) {
        this.recipients = new Recipients(userIds);
        this.title = title;
        this.text = text;
        this.url = url;
        this.type = type;
    }

    public Activity(@NotNull Set<String> userIds, @NotNull Set<String> groups, @NotNull String title, String url, String text, @NotNull String type) {
        this.recipients = new Recipients(userIds, groups);
        this.title = title;
        this.text = text;
        this.url = url;
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Activity activity = (Activity)o;
        return new EqualsBuilder().append((Object)this.getType(), (Object)activity.getType()).append((Object)this.getTitle(), (Object)activity.getTitle()).append((Object)this.getUrl(), (Object)activity.getUrl()).append((Object)this.getRecipients(), (Object)activity.getRecipients()).append((Object)this.getText(), (Object)activity.getText()).append((Object)this.getSendEmail(), (Object)activity.getSendEmail()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getType()).append((Object)this.getTitle()).append((Object)this.getUrl()).append((Object)this.getRecipients()).append((Object)this.getText()).append((Object)this.getSendEmail()).toHashCode();
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(@NotNull String type) {
        this.type = type;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@NotNull String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(@NotNull String url) {
        this.url = url;
    }

    @Override
    public Recipients getRecipients() {
        return this.recipients;
    }

    public void setRecipients(@NotNull Recipients recipients) {
        this.recipients = recipients;
    }

    public String getText() {
        return this.text;
    }

    public void setText(@NotNull String text) {
        this.text = text;
    }

    @Override
    public Set<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new HashSet<Tag>();
        }
        return this.tags;
    }

    public void setTags(@NotNull Set<Tag> tags) {
        this.tags = tags;
    }

    public void setTags(@NotNull Tag tag) {
        this.getTags().add(tag);
    }

    @JsonProperty(value="send_email")
    public Boolean getSendEmail() {
        return this.sendEmail;
    }

    public void setSendEmail(Boolean sendEmail) {
        this.sendEmail = sendEmail;
    }

    @Override
    @JsonIgnore
    public GroupService getGroupService() {
        return this.groupService;
    }

    @Override
    @JsonIgnore
    public UserLookupInterface getUserLookupInterface() {
        return this.userLookupInterface;
    }

    public Activity setGroupService(@NotNull GroupService groupService) {
        this.groupService = groupService;
        return this;
    }

    public Activity setUserLookupInterface(@NotNull UserLookupInterface userLookupInterface) {
        this.userLookupInterface = userLookupInterface;
        return this;
    }
}

