/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick.model;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.time.Duration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import uk.ac.warwick.util.mywarwick.model.Configuration;
import uk.ac.warwick.util.mywarwick.model.Instance;

@Singleton
public class TypesafeConfiguration
implements Configuration {
    private Config config;
    private Set<Instance> instanceSet;

    @Inject
    public TypesafeConfiguration(@Named(value="myWarwickConfig") Config typeSafeConfig) {
        Properties props = Configuration.loadDefaults();
        Config defaults = ConfigFactory.parseProperties((Properties)props);
        this.config = typeSafeConfig.withFallback((ConfigMergeable)defaults);
    }

    private void initConfigList() {
        this.instanceSet = this.config.getConfigList("mywarwick.instances").stream().map(e -> {
            String logErrors = null;
            try {
                logErrors = e.getString("logErrors");
            }
            catch (ConfigException.Missing missing) {
                // empty catch block
            }
            return new Instance(e.getString("baseUrl"), e.getString("providerId"), e.getString("userName"), e.getString("password"), logErrors);
        }).collect(Collectors.toSet());
    }

    @Override
    public Set<Instance> getInstances() {
        if (this.instanceSet == null) {
            this.instanceSet = new HashSet<Instance>();
            this.initConfigList();
        }
        return this.instanceSet;
    }

    @Override
    public int getHttpMaxConn() {
        return this.config.getInt("mywarwick.http.maxConn");
    }

    @Override
    public int getHttpMaxConnPerRoute() {
        return this.config.getInt("mywarwick.http.maxConnPerRoute");
    }

    @Override
    public String getQuartzHealthcheckName() {
        return this.config.getString("mywarwick.quartz.healthcheck.name");
    }

    @Override
    public long getQuartzHealthcheckQueueSizeWarningThreshold() {
        return this.config.getLong("mywarwick.quartz.healthcheck.queueSize.warning");
    }

    @Override
    public long getQuartzHealthcheckQueueSizeCriticalThreshold() {
        return this.config.getLong("mywarwick.quartz.healthcheck.queueSize.critical");
    }

    @Override
    public Duration getQuartzHealthcheckDelayWarningThreshold() {
        try {
            return this.config.getDuration("mywarwick.quartz.healthcheck.delay.warning");
        }
        catch (ConfigException.BadValue e) {
            return Duration.parse(this.config.getString("mywarwick.quartz.healthcheck.delay.warning"));
        }
    }

    @Override
    public Duration getQuartzHealthcheckDelayCriticalThreshold() {
        try {
            return this.config.getDuration("mywarwick.quartz.healthcheck.delay.critical");
        }
        catch (ConfigException.BadValue e) {
            return Duration.parse(this.config.getString("mywarwick.quartz.healthcheck.delay.critical"));
        }
    }
}

