/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.quartz.JobBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.core.DateTimeUtils;
import uk.ac.warwick.util.mywarwick.DefaultMyWarwickHttpResponseCallbackHelper;
import uk.ac.warwick.util.mywarwick.HasRegistrationHttpResponseCallback;
import uk.ac.warwick.util.mywarwick.HttpClient;
import uk.ac.warwick.util.mywarwick.MyWarwickHttpResponseCallback;
import uk.ac.warwick.util.mywarwick.MyWarwickHttpResponseCallbackHelper;
import uk.ac.warwick.util.mywarwick.MyWarwickService;
import uk.ac.warwick.util.mywarwick.RetryingHttpResponseCallback;
import uk.ac.warwick.util.mywarwick.SendMyWarwickActivityJob;
import uk.ac.warwick.util.mywarwick.model.Configuration;
import uk.ac.warwick.util.mywarwick.model.Instance;
import uk.ac.warwick.util.mywarwick.model.request.Activity;
import uk.ac.warwick.util.mywarwick.model.request.PushNotification;
import uk.ac.warwick.util.mywarwick.model.response.Response;

@Named
@Singleton
public class MyWarwickServiceImpl
implements MyWarwickService {
    private final Logger LOGGER = LoggerFactory.getLogger(MyWarwickServiceImpl.class);
    private final Set<Instance> instances;
    private final HttpClient httpclient;
    private final ObjectMapper mapper = new ObjectMapper();
    private final MyWarwickHttpResponseCallbackHelper callbackHelper = new DefaultMyWarwickHttpResponseCallbackHelper();

    @Inject
    public MyWarwickServiceImpl(HttpClient httpclient, Configuration configuration) {
        configuration.validate();
        this.httpclient = httpclient;
        this.instances = configuration.getInstances();
        httpclient.start();
    }

    private CompletableFuture<List<Response>> sendImmediately(Activity activity, boolean isNotification, boolean isTransient, int maxAttempts) {
        return this.sendImmediately(this.makeJsonBody(activity), isNotification, isTransient, maxAttempts);
    }

    private CompletableFuture<List<Response>> sendImmediately(String requestJson, boolean isNotification, boolean isTransient, int maxAttempts) {
        List<CompletableFuture> listOfCompletableFutures = this.instances.stream().map(instance -> this.sendSingleInstance((Instance)instance, requestJson, isNotification, isTransient, maxAttempts)).collect(Collectors.toList());
        return CompletableFuture.allOf(listOfCompletableFutures.toArray(new CompletableFuture[0])).thenApply(v -> listOfCompletableFutures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Response> sendSingleInstance(Instance instance, String requestJson, boolean isNotification, boolean isTransient, int maxAttempts) {
        CompletableFuture<Response> completableFuture = new CompletableFuture<Response>();
        String reqPath = isTransient && isNotification ? instance.getTransientPushPath() : (isNotification ? instance.getNotificationPath() : instance.getActivityPath());
        HttpPost request = this.makeRequest(reqPath, requestJson, instance.getApiUser(), instance.getApiPassword(), instance.getProviderId());
        MyWarwickHttpResponseCallback myWarwickHttpResponseCallback = new MyWarwickHttpResponseCallback(reqPath, requestJson, instance, this.LOGGER, completableFuture, this.callbackHelper);
        RetryingHttpResponseCallback retryingHttpResponseCallback = new RetryingHttpResponseCallback(this.httpclient, (HttpRequestBase)request, myWarwickHttpResponseCallback, this.LOGGER, maxAttempts);
        this.httpclient.execute((HttpUriRequest)request, retryingHttpResponseCallback);
        return completableFuture;
    }

    @Override
    public CompletableFuture<List<Response>> sendAsActivity(Activity activity) {
        return this.sendImmediately(activity, false, false, 3);
    }

    @Override
    public CompletableFuture<List<Response>> sendAsActivity(Activity activity, int maxAttempts) {
        return this.sendImmediately(activity, false, false, maxAttempts);
    }

    @Override
    public CompletableFuture<List<Response>> sendAsNotification(Activity activity) {
        return this.sendImmediately(activity, true, false, 3);
    }

    @Override
    public CompletableFuture<List<Response>> sendAsNotification(Activity activity, int maxAttempts) {
        return this.sendImmediately(activity, true, false, maxAttempts);
    }

    @Override
    public CompletableFuture<List<Response>> sendAsTransientPush(PushNotification pushNotification) {
        return this.sendImmediately(pushNotification, true, true, 3);
    }

    @Override
    public CompletableFuture<List<Response>> sendAsTransientPush(PushNotification pushNotification, int maxAttempts) {
        return this.sendImmediately(pushNotification, true, true, maxAttempts);
    }

    private void ensureJobExists(Scheduler scheduler) throws SchedulerException {
        if (!scheduler.checkExists(SendMyWarwickActivityJob.JOB_KEY)) {
            this.LOGGER.info("Creating job: " + SendMyWarwickActivityJob.JOB_KEY);
            scheduler.addJob(JobBuilder.newJob(SendMyWarwickActivityJob.class).withIdentity(SendMyWarwickActivityJob.JOB_KEY).storeDurably().requestRecovery().build(), true);
        }
    }

    private void queue(Activity activity, boolean isNotification, boolean isTransient, Scheduler scheduler) throws SchedulerException {
        this.ensureJobExists(scheduler);
        for (Instance instance : this.instances) {
            scheduler.scheduleJob(TriggerBuilder.newTrigger().forJob(SendMyWarwickActivityJob.JOB_KEY).usingJobData("instanceBaseUrl", instance.getBaseUrl()).usingJobData("requestBody", this.makeJsonBody(activity)).usingJobData("isNotification", Boolean.toString(isNotification)).usingJobData("isTransient", Boolean.toString(isTransient)).usingJobData("createdDateTimeISO8601", OffsetDateTime.now(DateTimeUtils.CLOCK_IMPLEMENTATION).toString()).build());
        }
    }

    @Override
    public void queueActivity(Activity activity, Scheduler scheduler) throws SchedulerException {
        this.queue(activity, false, false, scheduler);
    }

    @Override
    public void queueNotification(Activity activity, Scheduler scheduler) throws SchedulerException {
        this.queue(activity, true, false, scheduler);
    }

    @Override
    public void queueTransientPush(PushNotification pushNotification, Scheduler scheduler) throws SchedulerException {
        this.queue(pushNotification, true, true, scheduler);
    }

    @Override
    public CompletableFuture<List<Boolean>> hasPushRegistration(@NotNull String userId) {
        List<CompletableFuture> listOfCompletableFutures = this.instances.stream().map(instance -> {
            HttpGet request = new HttpGet(instance.getHasPushRegistrationPath().replace(instance.getUsercodeReplaceString(), userId));
            CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
            request.addHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((instance.getApiUser() + ":" + instance.getApiPassword()).getBytes(StandardCharsets.UTF_8)));
            request.addHeader("User-Agent", "MyWarwickService");
            HasRegistrationHttpResponseCallback myWarwickHttpResponseCallback = new HasRegistrationHttpResponseCallback(request.getURI().getPath(), (Instance)instance, this.LOGGER, completableFuture);
            RetryingHttpResponseCallback retryingHttpResponseCallback = new RetryingHttpResponseCallback(this.httpclient, (HttpRequestBase)request, myWarwickHttpResponseCallback, this.LOGGER, 3);
            this.httpclient.execute((HttpUriRequest)request, retryingHttpResponseCallback);
            return completableFuture;
        }).collect(Collectors.toList());
        return CompletableFuture.allOf(listOfCompletableFutures.toArray(new CompletableFuture[0])).thenApply(v -> listOfCompletableFutures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    String makeJsonBody(Activity activity) {
        String jsonString;
        try {
            jsonString = this.mapper.writeValueAsString((Object)activity);
        }
        catch (JsonProcessingException e) {
            this.LOGGER.error(e.getMessage());
            jsonString = "{}";
        }
        return jsonString;
    }

    HttpPost makeRequest(String path, String json, String apiUser, String apiPassword, String providerId) {
        HttpPost request = new HttpPost(path);
        request.addHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((apiUser + ":" + apiPassword).getBytes(StandardCharsets.UTF_8)));
        request.addHeader("Content-type", "application/json");
        request.addHeader("User-Agent", "MyWarwickService/" + providerId);
        request.setEntity((HttpEntity)new StringEntity(json, StandardCharsets.UTF_8));
        return request;
    }

    Set<Instance> getInstances() {
        return this.instances;
    }

    HttpClient getHttpClient() {
        return this.httpclient;
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.httpclient.destroy();
    }
}

