/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.mywarwick.HttpClient;
import uk.ac.warwick.util.mywarwick.HttpClientImpl;
import uk.ac.warwick.util.mywarwick.MyWarwickService;
import uk.ac.warwick.util.mywarwick.MyWarwickServiceImpl;
import uk.ac.warwick.util.mywarwick.model.Configuration;
import uk.ac.warwick.util.mywarwick.model.TypesafeConfiguration;
import uk.ac.warwick.util.mywarwick.model.request.ActivityFactory;
import uk.ac.warwick.util.mywarwick.model.request.ActivityFactoryImpl;

public class MyWarwickModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyWarwickModule.class);

    protected void configure() {
        this.bind(MyWarwickService.class).to(MyWarwickServiceImpl.class);
        this.bind(Configuration.class).to(TypesafeConfiguration.class);
        this.bind(HttpClient.class).to(HttpClientImpl.class);
        this.bind(ActivityFactory.class).to(ActivityFactoryImpl.class);
        try {
            Class.forName("uk.ac.warwick.util.service.ServiceHealthcheckProvider");
            this.requireBinding(Class.forName("org.quartz.Scheduler"));
            Class.forName("com.google.inject.multibindings.Multibinder");
            this.install((Module)Class.forName("uk.ac.warwick.util.mywarwick.healthcheck.MyWarwickHealthcheckModule").newInstance());
        }
        catch (Throwable t) {
            LOGGER.info("Not binding MyWarwickService health check because not all dependencies are available", t);
        }
    }

    @Named(value="myWarwickConfig")
    @Provides
    public Config provideConfigWithUnderlyingPlayConfig(play.api.Configuration playConfig) {
        return playConfig.underlying();
    }
}

