/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.warwick.util.mywarwick.model.Instance;
import uk.ac.warwick.util.mywarwick.model.TypesafeConfiguration;

public class TypesafeConfigurationTest {
    Config typeSafeConfigProperties;
    private TypesafeConfiguration typesafeConfigs;

    @Before
    public void setup() {
        this.typeSafeConfigProperties = ConfigFactory.parseString((String)"mywarwick.instances = [\n   {\n    baseUrl=\"1\"\n    providerId=\"2\"\n    userName=\"3\"\n    password=\"4\"\n    logErrors=\"false\"\n  }\n  {\n    baseUrl=\"5\"\n    providerId=\"6\"\n    userName=\"7\"\n    password=\"8\"\n  }\n]");
        this.typesafeConfigs = new TypesafeConfiguration(this.typeSafeConfigProperties);
    }

    @Test
    public void shouldLoadAndFormatTypeSafeConfigsIntoConfigs() {
        HashSet<Instance> expected = new HashSet<Instance>();
        expected.add(new Instance("1", "2", "3", "4", "false"));
        expected.add(new Instance("5", "6", "7", "8", "true"));
        Assert.assertEquals(expected, (Object)this.typesafeConfigs.getInstances());
    }

    @Test
    public void defaultValues() {
        Assert.assertEquals((long)200L, (long)this.typesafeConfigs.getHttpMaxConn());
    }
}

