/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import uk.ac.warwick.util.mywarwick.MyWarwickService;
import uk.ac.warwick.util.mywarwick.SendMyWarwickActivityJob;
import uk.ac.warwick.util.mywarwick.model.Configuration;
import uk.ac.warwick.util.mywarwick.model.Instance;
import uk.ac.warwick.util.mywarwick.model.TestConfiguration;
import uk.ac.warwick.util.mywarwick.model.response.Error;
import uk.ac.warwick.util.mywarwick.model.response.Response;

public class SendMyWarwickActivityJobTest {
    private final Mockery m = new JUnit4Mockery();
    private final MyWarwickService myWarwickService = (MyWarwickService)this.m.mock(MyWarwickService.class);
    private final Scheduler scheduler = (Scheduler)this.m.mock(Scheduler.class);
    private JobExecutionContext context;
    private JobDataMap jobDataMap;
    private final Instance prodInstance = new Instance("https://my.warwick.ac.uk", null, null, null, null);
    private final Instance testInstance = new Instance("https://my-test.warwick.ac.uk", null, null, null, null);
    private SendMyWarwickActivityJob job;
    private final Trigger trigger = (Trigger)this.m.mock(Trigger.class);
    private final TriggerKey triggerKey = new TriggerKey(UUID.randomUUID().toString(), SendMyWarwickActivityJob.JOB_KEY.getGroup());
    private CompletableFuture<Response> future;

    @Before
    public void setUp() {
        final HashSet<Instance> instances = new HashSet<Instance>();
        instances.add(this.prodInstance);
        instances.add(this.testInstance);
        this.job = new SendMyWarwickActivityJob(this.myWarwickService, this.scheduler, (Configuration)new TestConfiguration(){

            public Set<Instance> getInstances() {
                return instances;
            }
        });
        this.context = (JobExecutionContext)this.m.mock(JobExecutionContext.class);
        this.jobDataMap = new JobDataMap();
        this.jobDataMap.put("instanceBaseUrl", "https://my-test.warwick.ac.uk");
        this.jobDataMap.put("requestBody", "{}");
        this.jobDataMap.putAsString("isNotification", true);
        this.jobDataMap.putAsString("isTransient", false);
        this.future = new CompletableFuture();
    }

    @Test
    public void reschedulesOnFailedFuture() throws Exception {
        this.future.completeExceptionally(new SocketTimeoutException());
        this.expectReschedule();
        this.job.execute(this.context);
        this.m.assertIsSatisfied();
    }

    @Test
    public void reschedulesOnCancelledFuture() throws Exception {
        this.future.cancel(true);
        this.expectReschedule();
        this.job.execute(this.context);
        this.m.assertIsSatisfied();
    }

    @Test
    public void retriesOnPermissionValidationError() throws Exception {
        Response value = new Response();
        value.setSuccess(Boolean.valueOf(false));
        Error error = new Error();
        error.setId("no-permission");
        error.setMessage("You forgot to grant the permission, silly!");
        value.setError(error);
        this.future.complete(value);
        this.expectReschedule();
        this.job.execute(this.context);
        this.m.assertIsSatisfied();
    }

    @Test
    public void cancelsOnValidationFailure() throws Exception {
        Response value = new Response();
        value.setSuccess(Boolean.valueOf(false));
        Error error = new Error();
        error.setId("bad-thing");
        error.setMessage("The request was invalid and retrying won't help");
        value.setError(error);
        this.future.complete(value);
        this.expectNoReschedule();
        this.job.execute(this.context);
        this.m.assertIsSatisfied();
    }

    @Test
    public void reschedulesOnNullSuccess() throws Exception {
        this.future.complete(new Response());
        this.expectReschedule();
        this.job.execute(this.context);
        this.m.assertIsSatisfied();
    }

    @Test
    public void notRescheduleOnSuccess() throws Exception {
        Response value = new Response();
        value.setSuccess(Boolean.valueOf(true));
        this.future.complete(value);
        this.expectNoReschedule();
        this.job.execute(this.context);
        this.m.assertIsSatisfied();
    }

    @Test
    public void transitionsJobDataForInstancelessInvocations() throws Exception {
        this.jobDataMap.clear();
        this.jobDataMap.put("requestBody", "{}");
        this.jobDataMap.putAsString("isNotification", true);
        this.jobDataMap.putAsString("isTransient", false);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((JobExecutionContext)this.atLeast(1).of((Object)SendMyWarwickActivityJobTest.this.context)).getMergedJobDataMap();
                this.will(2.returnValue((Object)SendMyWarwickActivityJobTest.this.jobDataMap));
                ((JobExecutionContext)this.atLeast(1).of((Object)SendMyWarwickActivityJobTest.this.context)).getTrigger();
                this.will(2.returnValue((Object)SendMyWarwickActivityJobTest.this.trigger));
                ((Trigger)this.atLeast(1).of((Object)SendMyWarwickActivityJobTest.this.trigger)).getJobDataMap();
                this.will(2.returnValue((Object)SendMyWarwickActivityJobTest.this.jobDataMap));
                ((Scheduler)this.oneOf(SendMyWarwickActivityJobTest.this.scheduler)).scheduleJob((Trigger)this.with((Matcher)new BaseMatcher<Trigger>(){

                    public boolean matches(Object o) {
                        if (!(o instanceof Trigger)) {
                            return false;
                        }
                        Trigger t = (Trigger)o;
                        return t.getJobDataMap().getString("instanceBaseUrl").equals(SendMyWarwickActivityJobTest.this.prodInstance.getBaseUrl());
                    }

                    public void describeTo(Description description) {
                        description.appendText("a trigger for prodInstance");
                    }
                }));
                ((Scheduler)this.oneOf(SendMyWarwickActivityJobTest.this.scheduler)).scheduleJob((Trigger)this.with((Matcher)new BaseMatcher<Trigger>(){

                    public boolean matches(Object o) {
                        if (!(o instanceof Trigger)) {
                            return false;
                        }
                        Trigger t = (Trigger)o;
                        return t.getJobDataMap().getString("instanceBaseUrl").equals(SendMyWarwickActivityJobTest.this.testInstance.getBaseUrl());
                    }

                    public void describeTo(Description description) {
                        description.appendText("a trigger for testInstance");
                    }
                }));
                this.never(SendMyWarwickActivityJobTest.this.myWarwickService);
            }
        });
        this.job.execute(this.context);
        this.m.assertIsSatisfied();
    }

    @After
    public void assertIsSatisfied() {
        this.m.assertIsSatisfied();
    }

    public void expectReschedule() throws Exception {
        this.maybeExpectReschedule(true);
    }

    public void expectNoReschedule() throws Exception {
        this.maybeExpectReschedule(false);
    }

    private void maybeExpectReschedule(boolean reschedule) throws Exception {
        final int invocationCount = reschedule ? 1 : 0;
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((JobExecutionContext)this.atLeast(1).of((Object)SendMyWarwickActivityJobTest.this.context)).getMergedJobDataMap();
                this.will(3.returnValue((Object)SendMyWarwickActivityJobTest.this.jobDataMap));
                ((MyWarwickService)this.oneOf(SendMyWarwickActivityJobTest.this.myWarwickService)).sendSingleInstance(SendMyWarwickActivityJobTest.this.testInstance, "{}", true, false, 3);
                this.will(3.returnValue((Object)SendMyWarwickActivityJobTest.this.future));
                ((JobExecutionContext)this.atLeast(invocationCount).of((Object)SendMyWarwickActivityJobTest.this.context)).getTrigger();
                this.will(3.returnValue((Object)SendMyWarwickActivityJobTest.this.trigger));
                ((Trigger)this.atLeast(invocationCount).of((Object)SendMyWarwickActivityJobTest.this.trigger)).getKey();
                this.will(3.returnValue((Object)SendMyWarwickActivityJobTest.this.triggerKey));
                ((Trigger)this.atLeast(invocationCount).of((Object)SendMyWarwickActivityJobTest.this.trigger)).getJobDataMap();
                this.will(3.returnValue((Object)SendMyWarwickActivityJobTest.this.jobDataMap));
                ((Scheduler)this.exactly(invocationCount).of((Object)SendMyWarwickActivityJobTest.this.scheduler)).rescheduleJob((TriggerKey)this.with(3.equal((Object)SendMyWarwickActivityJobTest.this.triggerKey)), (Trigger)this.with(3.aNonNull(Trigger.class)));
            }
        });
    }
}

