package uk.ac.warwick.util.mywarwick.model;

import org.springframework.core.env.PropertyResolver;

/**
 * Configuration for a Spring application where you don't have a Properties object full of all
 * the properties, but you do have the Environment that has access to all the configuration keys.
 */
public class SpringEnvironmentConfiguration extends AbstractSpringConfiguration {
  private final PropertyResolver environment;

  public SpringEnvironmentConfiguration(PropertyResolver environment) {
    this.environment = environment;
  }

  @Override
  protected String getOrNull(String key) {
    return environment.getProperty(key);
  }

  @Override
  boolean keyExists(String key) {
    return environment.containsProperty(key);
  }
}