package uk.ac.warwick.util.mywarwick;

import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import uk.ac.warwick.util.mywarwick.model.Instance;
import uk.ac.warwick.util.mywarwick.model.request.Activity;
import uk.ac.warwick.util.mywarwick.model.request.PushNotification;
import uk.ac.warwick.util.mywarwick.model.response.Response;

import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface MyWarwickService {
    int DEFAULT_MAX_ATTEMPTS = 3;

    CompletableFuture<List<Response>> sendAsActivity(Activity activity);
    CompletableFuture<List<Response>> sendAsActivity(Activity activity, int maxAttempts);
    CompletableFuture<List<Response>> sendAsNotification(Activity activity);
    CompletableFuture<List<Response>> sendAsNotification(Activity activity, int maxAttempts);

    /**
     * Sending transient push notifications may require your 'Provider'
     * to have additional permission from the My Warwick app instance
     */
    CompletableFuture<List<Response>> sendAsTransientPush(PushNotification pushNotification);
    CompletableFuture<List<Response>> sendAsTransientPush(PushNotification pushNotification, int maxAttempts);

    void queueActivity(Activity activity, Scheduler scheduler) throws SchedulerException;
    void queueNotification(Activity activity, Scheduler scheduler) throws SchedulerException;
    void queueTransientPush(PushNotification pushNotification, Scheduler scheduler) throws SchedulerException;

    /**
     * For internal use only
     */
    CompletableFuture<Response> sendSingleInstance(Instance instance, String requestJson, boolean isNotification, boolean isTransient, int maxAttempts);
    CompletableFuture<List<Boolean>> hasPushRegistration(@NotNull String userId);
}
