/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.ac.warwick.util.mywarwick.model.response.Data;
import uk.ac.warwick.util.mywarwick.model.response.Error;
import uk.ac.warwick.util.mywarwick.model.response.Warning;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Response {
    Boolean success;
    String status;
    Data data;
    List<Error> errors;
    List<Warning> warnings;

    public Response() {
        this.errors = new ArrayList<Error>();
        this.warnings = new ArrayList<Warning>();
    }

    public Response(Boolean success, String status, Data data, List<Error> errors) {
        this.success = success;
        this.status = status;
        this.data = data;
        this.errors = errors;
    }

    public Response(Boolean success, String status, Data data, Error error) {
        this.success = success;
        this.status = status;
        this.data = data;
        this.errors = new ArrayList<Error>();
        this.errors.add(error);
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<Warning> warnings) {
        this.warnings = warnings;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public void setError(Error error) {
        if (this.errors == null) {
            this.errors = new ArrayList<Error>();
        }
        this.errors.add(error);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Response response = (Response)o;
        return new EqualsBuilder().append((Object)this.getSuccess(), (Object)response.getSuccess()).append((Object)this.getStatus(), (Object)response.getStatus()).append((Object)this.getData(), (Object)response.getData()).append(this.getErrors(), response.getErrors()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getSuccess()).append((Object)this.getStatus()).append((Object)this.getData()).append(this.getErrors()).toHashCode();
    }

    public String toString() {
        return "Response{success=" + this.success + ", status='" + this.status + '\'' + ", data=" + this.data + ", errors=" + this.errors + '}';
    }
}

