/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.core.env.PropertyResolver;
import org.springframework.mock.env.MockEnvironment;
import uk.ac.warwick.util.mywarwick.model.Instance;
import uk.ac.warwick.util.mywarwick.model.SpringEnvironmentConfiguration;

public class SpringEnvironmentConfigurationTest {
    SpringEnvironmentConfiguration configuration;

    @Before
    public void setup() {
        MockEnvironment environment = new MockEnvironment();
        environment.setProperty("mywarwick.instances.0.baseUrl", "1");
        environment.setProperty("mywarwick.instances.0.providerId", "2");
        environment.setProperty("mywarwick.instances.0.userName", "3");
        environment.setProperty("mywarwick.instances.0.password", "4");
        environment.setProperty("mywarwick.instances.1.baseUrl", "5");
        environment.setProperty("mywarwick.instances.1.providerId", "6");
        environment.setProperty("mywarwick.instances.1.userName", "7");
        environment.setProperty("mywarwick.instances.1.password", "8");
        environment.setProperty("mywarwick.instances.1.logErrors", "false");
        this.configuration = new SpringEnvironmentConfiguration((PropertyResolver)environment);
    }

    @Test
    public void shouldReadPropertiesFileAndFormatToConfiguration() {
        HashSet<Instance> expected = new HashSet<Instance>();
        expected.add(new Instance("1", "2", "3", "4", "true"));
        expected.add(new Instance("5", "6", "7", "8", "false"));
        Assert.assertEquals(expected, (Object)this.configuration.getInstances());
    }

    @Test
    public void defaults() {
        Assert.assertEquals((long)200L, (long)this.configuration.getHttpMaxConn());
    }
}

