/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import java.util.HashSet;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.warwick.util.mywarwick.model.Instance;
import uk.ac.warwick.util.mywarwick.model.PropertiesConfiguration;

public class PropertiesConfigurationTest {
    PropertiesConfiguration propertiesConfiguration;

    @Before
    public void setup() {
        Properties properties = new Properties();
        properties.setProperty("mywarwick.instances.0.baseUrl", "1");
        properties.setProperty("mywarwick.instances.0.providerId", "2");
        properties.setProperty("mywarwick.instances.0.userName", "3");
        properties.setProperty("mywarwick.instances.0.password", "4");
        properties.setProperty("mywarwick.instances.1.baseUrl", "5");
        properties.setProperty("mywarwick.instances.1.providerId", "6");
        properties.setProperty("mywarwick.instances.1.userName", "7");
        properties.setProperty("mywarwick.instances.1.password", "8");
        properties.setProperty("mywarwick.instances.1.logErrors", "false");
        this.propertiesConfiguration = new PropertiesConfiguration(properties);
    }

    @Test
    public void shouldReadPropertiesFileAndFormatToConfiguration() {
        HashSet<Instance> expected = new HashSet<Instance>();
        expected.add(new Instance("1", "2", "3", "4", "true"));
        expected.add(new Instance("5", "6", "7", "8", "false"));
        Assert.assertEquals(expected, (Object)this.propertiesConfiguration.getInstances());
    }

    @Test
    public void defaults() {
        Assert.assertEquals((long)200L, (long)this.propertiesConfiguration.getHttpMaxConn());
    }
}

