/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.mywarwick.MyWarwickHttpResponseCallbackHelper;
import uk.ac.warwick.util.mywarwick.model.response.Data;
import uk.ac.warwick.util.mywarwick.model.response.Error;
import uk.ac.warwick.util.mywarwick.model.response.Response;
import uk.ac.warwick.util.mywarwick.model.response.Warning;

public class MyWarwickHttpResponseCallbackHelperTest {
    ObjectMapper objectMapper = new ObjectMapper();
    final String failedJsonResponse = "{\"success\":true,\"status\":\"string\",\"errors\":[{\"id\":\"no-permission\",\"message\":\"User'example-user'doesnothavepermissiontoposttothestreamforprovider'example-provider'\"}]}";
    final String successJsonResponse = "{\"success\":true,\"status\":\"ok\",\"data\":{\"id\":\"9e71b33b-debd-40e5-8e6c-989c9de8c547\"}}";
    final String successWithWarningResponse = "{\"success\":true,\"status\":\"ok\",\"data\":{\"id\":\"fb97dfd7-df8e-4fcd-ab23-241e59c8358c\"},\"warnings\":[{\"id\":\"InvalidUsercodeAudience\",\"message\":\"The request contains one or more invalid usercode: List()\"}]}";
    final String responseWithUnknownProperty = "{\"success\":true,\"status\":\"ok\",\"data\":{\"id\":\"fb97dfd7-df8e-4fcd-ab23-241e59c8358c\"},\"cat\":{\"colour\":\"black\"},\"warnings\":[{\"id\":\"InvalidUsercodeAudience\",\"message\":\"The request contains one or more invalid usercode: List()\"}]}";
    final String responseWithUnknownPropertyUnderKnownProperty = "{\"success\":true,\"status\":\"ok\",\"data\":{\"id\":\"fb97dfd7-df8e-4fcd-ab23-241e59c8358c\"},\"cat\":{\"colour\":\"black\"},\"warnings\":[{\"id\":\"InvalidUsercodeAudience\",\"message\":\"The request contains one or more invalid usercode: List()\",\"why\":\"this is a peach\"}]}";
    final String responseWithEvenMoreRandomUnknownProperties = "{\"success\":true,\"status\":\"ok\",\"data\":{\"id\":\"fb97dfd7-df8e-4fcd-ab23-241e59c8358c\",\"oh\":\"dear\"},\"cat\":{\"colour\":\"black\"},\"warnings\":[{\"id\":\"InvalidUsercodeAudience\",\"message\":\"The request contains one or more invalid usercode: List()\",\"why\":\"this is a peach\"}]}";

    @Test
    public void shouldMapSuccessResponseToObjectCorrectly() throws IOException {
        Response response = new Response();
        response.setSuccess(Boolean.valueOf(true));
        response.setStatus("ok");
        response.setData(new Data("fb97dfd7-df8e-4fcd-ab23-241e59c8358c"));
        response.setWarnings(Collections.singletonList(new Warning("InvalidUsercodeAudience", "The request contains one or more invalid usercode: List()")));
        Assert.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)MyWarwickHttpResponseCallbackHelper.parseJsonStringToResponseObject((String)"{\"success\":true,\"status\":\"ok\",\"data\":{\"id\":\"fb97dfd7-df8e-4fcd-ab23-241e59c8358c\"},\"warnings\":[{\"id\":\"InvalidUsercodeAudience\",\"message\":\"The request contains one or more invalid usercode: List()\"}]}", (ObjectMapper)this.objectMapper), (Object)response, (String[])new String[0]));
    }

    @Test
    public void shouldMapSuccessWithWarningResponseToObjectCorrectly() throws IOException {
        Response response = new Response();
        response.setSuccess(Boolean.valueOf(true));
        response.setStatus("ok");
        response.setData(new Data("9e71b33b-debd-40e5-8e6c-989c9de8c547"));
        Assert.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)MyWarwickHttpResponseCallbackHelper.parseJsonStringToResponseObject((String)"{\"success\":true,\"status\":\"ok\",\"data\":{\"id\":\"9e71b33b-debd-40e5-8e6c-989c9de8c547\"}}", (ObjectMapper)this.objectMapper), (Object)response, (String[])new String[0]));
    }

    @Test
    public void shouldMapFailedResponseToObjectCorrectly() throws IOException {
        Response response = new Response();
        response.setSuccess(Boolean.valueOf(true));
        response.setStatus("string");
        response.setError(new Error("no-permission", "User'example-user'doesnothavepermissiontoposttothestreamforprovider'example-provider'"));
        Assert.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)MyWarwickHttpResponseCallbackHelper.parseJsonStringToResponseObject((String)"{\"success\":true,\"status\":\"string\",\"errors\":[{\"id\":\"no-permission\",\"message\":\"User'example-user'doesnothavepermissiontoposttothestreamforprovider'example-provider'\"}]}", (ObjectMapper)this.objectMapper), (Object)response, (String[])new String[0]));
    }

    @Test
    public void shouldNotFailIfJsonContainsUnknownProperty() throws IOException {
        Response response = new Response();
        response.setSuccess(Boolean.valueOf(true));
        response.setStatus("ok");
        response.setWarnings(Collections.singletonList(new Warning("InvalidUsercodeAudience", "The request contains one or more invalid usercode: List()")));
        response.setData(new Data("fb97dfd7-df8e-4fcd-ab23-241e59c8358c"));
        Assert.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)MyWarwickHttpResponseCallbackHelper.parseJsonStringToResponseObject((String)"{\"success\":true,\"status\":\"ok\",\"data\":{\"id\":\"fb97dfd7-df8e-4fcd-ab23-241e59c8358c\"},\"cat\":{\"colour\":\"black\"},\"warnings\":[{\"id\":\"InvalidUsercodeAudience\",\"message\":\"The request contains one or more invalid usercode: List()\"}]}", (ObjectMapper)this.objectMapper), (Object)response, (String[])new String[0]));
        Assert.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)MyWarwickHttpResponseCallbackHelper.parseJsonStringToResponseObject((String)"{\"success\":true,\"status\":\"ok\",\"data\":{\"id\":\"fb97dfd7-df8e-4fcd-ab23-241e59c8358c\"},\"cat\":{\"colour\":\"black\"},\"warnings\":[{\"id\":\"InvalidUsercodeAudience\",\"message\":\"The request contains one or more invalid usercode: List()\",\"why\":\"this is a peach\"}]}", (ObjectMapper)this.objectMapper), (Object)response, (String[])new String[0]));
        Assert.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)MyWarwickHttpResponseCallbackHelper.parseJsonStringToResponseObject((String)"{\"success\":true,\"status\":\"ok\",\"data\":{\"id\":\"fb97dfd7-df8e-4fcd-ab23-241e59c8358c\",\"oh\":\"dear\"},\"cat\":{\"colour\":\"black\"},\"warnings\":[{\"id\":\"InvalidUsercodeAudience\",\"message\":\"The request contains one or more invalid usercode: List()\",\"why\":\"this is a peach\"}]}", (ObjectMapper)this.objectMapper), (Object)response, (String[])new String[0]));
    }
}

