package uk.ac.warwick.util.mywarwick;

import akka.actor.ActorSystem;
import akka.testkit.javadsl.TestKit;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.quartz.Scheduler;
import org.quartz.impl.StdScheduler;
import play.api.Configuration;
import uk.ac.warwick.userlookup.GroupService;
import uk.ac.warwick.userlookup.UserLookupAdapter;
import uk.ac.warwick.userlookup.UserLookupInterface;
import uk.ac.warwick.userlookup.webgroups.GroupServiceAdapter;

public class MyWarwickModuleTest {
    static ActorSystem system;

    @BeforeClass
    public static void createActorSystem() {
        system = ActorSystem.create();
    }

    @AfterClass
    public static void tearDownActorSystem() {
        TestKit.shutdownActorSystem(system);
        system = null;
    }

    public static class TestModule extends AbstractModule {
        protected void configure() {
            // This emulates what Play does, providing a Configuration.
            bind(Configuration.class).toInstance(Configuration.apply(ConfigFactory.empty()));
            bind(GroupService.class).toInstance(new FakeGroupService());
            bind(UserLookupInterface.class).toInstance(new FakeUserLookupService());
            bind(Scheduler.class).toInstance(new StdScheduler(null));
            bind(ActorSystem.class).toInstance(system);
        }
    }

    public static class EmptyConfigModule extends AbstractModule {
        protected void configure() {

        }

        // a rogue Config provider! Make sure it doesn't clash with the one in the module.
        @Provides
        public Config newConfig() {
            return ConfigFactory.empty();
        }
    }

    @Test
    public void noConflicts() {
        Injector injector = Guice.createInjector(new TestModule(), new MyWarwickModule());
    }

    @Test
    public void conflicts() {
        Injector injector = Guice.createInjector(new EmptyConfigModule(), new TestModule(), new MyWarwickModule());
    }

}

class FakeUserLookupService extends UserLookupAdapter {
    FakeUserLookupService() {
        super(null);
    }
}

class FakeGroupService extends GroupServiceAdapter {
    FakeGroupService() {
        super(null);
    }
}
