package uk.ac.warwick.util.mywarwick.healthcheck;

import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import uk.ac.warwick.util.service.ServiceHealthcheckProvider;

public class MyWarwickHealthcheckModule extends AbstractModule {

    @Override
    protected void configure() {
        Multibinder<ServiceHealthcheckProvider> healthchecks = Multibinder.newSetBinder(binder(), TypeLiteral.get(ServiceHealthcheckProvider.class));
        healthchecks.addBinding().to(PlayMyWarwickQuartzHealthcheckProvider.class);
    }

}
