/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mail;

import java.net.UnknownHostException;
import org.junit.Assert;
import org.junit.Test;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import uk.ac.warwick.util.mail.EmailAddressChecker;

public class EmailAddressCheckerTest {
    @Test
    public void itWorks() {
        EmailAddressChecker checker = new EmailAddressChecker("mat.mannion@gmail.com");
        Assert.assertFalse((boolean)checker.isEmpty());
        Assert.assertTrue((boolean)checker.isMatches());
        Assert.assertTrue((boolean)checker.isValid());
        checker = new EmailAddressChecker("m.mannion@warwick.ac.uk");
        Assert.assertFalse((boolean)checker.isEmpty());
        Assert.assertTrue((boolean)checker.isMatches());
        Assert.assertTrue((boolean)checker.isValid());
        checker = new EmailAddressChecker("invalid@inv.alid");
        Assert.assertFalse((boolean)checker.isEmpty());
        Assert.assertFalse((boolean)checker.isMatches());
        Assert.assertFalse((boolean)checker.isValid());
    }

    @Test
    public void testDnsServerFailure() throws UnknownHostException {
        SimpleResolver resolver = new SimpleResolver("203.0.113.42");
        resolver.setTimeout(3);
        Lookup.setDefaultResolver((Resolver)resolver);
        EmailAddressChecker checker = new EmailAddressChecker("m.mannion@warwick.ac.uk");
        Assert.assertFalse((boolean)checker.isEmpty());
        Assert.assertFalse((boolean)checker.isMatches());
        Assert.assertTrue((boolean)checker.isServerError());
        Assert.assertTrue((boolean)checker.isValid());
        Lookup.refreshDefault();
    }
}

