/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.lookup.departments;

import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.cache.Cache;
import uk.ac.warwick.util.cache.CacheEntryFactory;
import uk.ac.warwick.util.cache.CacheEntryUpdateException;
import uk.ac.warwick.util.cache.Caches;
import uk.ac.warwick.util.core.lookup.departments.Faculty;
import uk.ac.warwick.util.core.lookup.departments.FacultyLookup;
import uk.ac.warwick.util.core.lookup.departments.Utils;
import uk.ac.warwick.util.httpclient.httpclient4.HttpMethodExecutor;
import uk.ac.warwick.util.httpclient.httpclient4.SimpleHttpMethodExecutor;

public class FacultyLookupImpl
implements FacultyLookup,
CacheEntryFactory<String, LinkedHashMap<String, Faculty>> {
    private static final String CACHE_NAME = "faculties";
    private static final String FACULTIES_KEY = "all.faculties";
    private static final Duration CACHE_EXPIRY = Duration.ofDays(7L);
    private static final SimpleDateFormat LAST_MODIFIED_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Logger LOGGER = LoggerFactory.getLogger(FacultyLookupImpl.class);
    private final Cache<String, LinkedHashMap<String, Faculty>> cache;
    private final String url;

    public FacultyLookupImpl(String url) {
        this.url = url;
        this.cache = Caches.builder((String)CACHE_NAME, (CacheEntryFactory)this, (Caches.CacheStrategy)Caches.CacheStrategy.CaffeineIfAvailable).expireAfterWrite(CACHE_EXPIRY).maximumSize(100L).build();
        this.getFaculty("X");
    }

    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public Faculty getFaculty(String code) {
        if (code == null) {
            return null;
        }
        try {
            return (Faculty)((LinkedHashMap)this.cache.get((Serializable)((Object)FACULTIES_KEY))).get(code.toUpperCase());
        }
        catch (CacheEntryUpdateException e) {
            LOGGER.error("Error updating cache, trying to fetch key " + code, (Throwable)e);
            return null;
        }
    }

    @Override
    public List<Faculty> getAllFaculties() {
        try {
            return new ArrayList<Faculty>(((LinkedHashMap)this.cache.get((Serializable)((Object)FACULTIES_KEY))).values());
        }
        catch (CacheEntryUpdateException e) {
            LOGGER.error("Error updating cache, trying to fetch all entries", (Throwable)e);
            return null;
        }
    }

    private static Faculty parseJsonToFaculty(JSONObject json) throws JSONException {
        Faculty f = new Faculty();
        f.setCode(json.getString("code"));
        f.setName(json.getString("name"));
        f.setCurrent(json.getBoolean("inUse"));
        f.setLastModified(Utils.getLastModified(json));
        return f;
    }

    public LinkedHashMap<String, Faculty> create(String ignored) throws CacheEntryUpdateException {
        HttpGet get = new HttpGet(this.url);
        try {
            LOGGER.info("Updating faculties from " + this.url);
            return (LinkedHashMap)new SimpleHttpMethodExecutor(HttpMethodExecutor.Method.get, this.url).execute((ResponseHandler)new ResponseHandler<LinkedHashMap<String, Faculty>>(){

                public LinkedHashMap<String, Faculty> handleResponse(HttpResponse response) throws IOException {
                    HttpEntity entity = response.getEntity();
                    try {
                        JSONArray jsonFaculties = new JSONArray(EntityUtils.toString((HttpEntity)entity));
                        ArrayList<Faculty> faculties = new ArrayList<Faculty>();
                        for (int i = 0; i < jsonFaculties.length(); ++i) {
                            JSONObject jsonFaculty = jsonFaculties.getJSONObject(i);
                            Faculty f = FacultyLookupImpl.parseJsonToFaculty(jsonFaculty);
                            faculties.add(f);
                        }
                        Collections.sort(faculties);
                        LinkedHashMap<String, Faculty> facultyMap = new LinkedHashMap<String, Faculty>();
                        for (Faculty f : faculties) {
                            facultyMap.put(f.getCode(), f);
                        }
                        return facultyMap;
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
            }).getRight();
        }
        catch (IOException e) {
            LOGGER.error("Unable to fetch department information from " + get.getURI().toString(), (Object)e.getMessage());
            throw new CacheEntryUpdateException((Throwable)e);
        }
    }

    public Map<String, LinkedHashMap<String, Faculty>> create(List<String> keys) throws CacheEntryUpdateException {
        throw new CacheEntryUpdateException("Unsupported cache operation");
    }

    public boolean isSupportsMultiLookups() {
        return false;
    }

    public boolean shouldBeCached(LinkedHashMap<String, Faculty> val) {
        return true;
    }
}

