/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.lookup;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import uk.ac.warwick.util.httpclient.httpclient4.HttpMethodExecutor;
import uk.ac.warwick.util.httpclient.httpclient4.HttpRequestDecorator;
import uk.ac.warwick.util.httpclient.httpclient4.SimpleHttpMethodExecutor;
import uk.ac.warwick.util.web.Uri;

public class TwitterAuthenticationHttpRequestDecorator
implements HttpRequestDecorator,
InitializingBean {
    private static final Uri DEFAULT_OAUTH_ENDPOINT_URL = Uri.parse((String)"https://api.twitter.com/oauth2/token");
    private final Uri oauthEndpointUri;
    private String consumerKey;
    private String consumerSecret;
    private String bearerToken;

    public TwitterAuthenticationHttpRequestDecorator() {
        this(DEFAULT_OAUTH_ENDPOINT_URL);
    }

    public TwitterAuthenticationHttpRequestDecorator(Uri theEndpointUri) {
        this.oauthEndpointUri = theEndpointUri;
    }

    public void decorate(HttpUriRequest request, HttpContext context) {
        request.addHeader("Authorization", "Bearer " + this.getBearerToken());
    }

    private synchronized String getBearerToken() {
        if (this.bearerToken != null) {
            return this.bearerToken;
        }
        try {
            String encodedKey = URLEncoder.encode(this.consumerKey, "UTF-8");
            String encodedSecret = URLEncoder.encode(this.consumerSecret, "UTF-8");
            String bearerCredentials = String.format("%s:%s", encodedKey, encodedSecret);
            String encodedBearerCredentials = new String(Base64.encodeBase64((byte[])bearerCredentials.getBytes("UTF-8")), "UTF-8");
            SimpleHttpMethodExecutor executor = new SimpleHttpMethodExecutor(HttpMethodExecutor.Method.post);
            executor.setUrl(this.oauthEndpointUri);
            executor.addHeader("Authorization", "Basic " + encodedBearerCredentials);
            executor.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            executor.setPostBody(Collections.singletonList(new BasicNameValuePair("grant_type", "client_credentials")));
            this.bearerToken = (String)executor.execute((ResponseHandler)new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    String responseText = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (response.getStatusLine().getStatusCode() != 200) {
                        throw new IllegalStateException(String.format("Expected HTTP 200 from Twitter OAuth 2 endpoint; received %d (content %s)", response.getStatusLine().getStatusCode(), responseText));
                    }
                    try {
                        JSONObject json = new JSONObject(responseText);
                        String tokenType = json.getString("token_type");
                        if (!"bearer".equals(tokenType)) {
                            throw new IllegalStateException(String.format("Expected bearer token from Twitter API (was %s)", tokenType));
                        }
                        return json.getString("access_token");
                    }
                    catch (JSONException e) {
                        throw new IllegalStateException(String.format("Invalid JSON received from Twitter API (received %s)", responseText), e);
                    }
                }
            }).getRight();
            return this.bearerToken;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 no longer supported!?!!??!", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't fetch bearer token from Twitter OAuth!", e);
        }
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public void afterPropertiesSet() {
        Assert.isTrue((boolean)StringUtils.hasText((String)this.consumerKey), (String)"Consumer key must be specified");
        Assert.isTrue((boolean)StringUtils.hasText((String)this.consumerSecret), (String)"Consumer secret must be specified");
    }
}

