/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.lookup;

import java.io.Serializable;
import java.time.Duration;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.cache.Cache;
import uk.ac.warwick.util.cache.CacheEntryFactory;
import uk.ac.warwick.util.cache.CacheEntryUpdateException;
import uk.ac.warwick.util.cache.Caches;
import uk.ac.warwick.util.cache.SingularCacheEntryFactory;
import uk.ac.warwick.util.collections.Pair;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.core.lookup.DepartmentWebsiteLookup;
import uk.ac.warwick.util.httpclient.httpclient4.HttpMethodExecutor;
import uk.ac.warwick.util.httpclient.httpclient4.SimpleHttpMethodExecutor;
import uk.ac.warwick.util.web.Uri;
import uk.ac.warwick.util.web.UriBuilder;

public final class GoWarwickDepartmentWebsiteLookup
implements DepartmentWebsiteLookup {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoWarwickDepartmentWebsiteLookup.class);
    public static final String CACHE_NAME = "DepartmentWebsiteCache";
    private static final Uri DEFAULT_GO_API_URL = Uri.parse((String)"https://sitebuilder.warwick.ac.uk/sitebuilder2/api/go/redirect.json");
    private static final Duration DEFAULT_CACHE_TIMEOUT = Duration.ofDays(1L);
    private final Cache<String, String> cache;

    public GoWarwickDepartmentWebsiteLookup() {
        this(DEFAULT_GO_API_URL);
    }

    public GoWarwickDepartmentWebsiteLookup(Uri goApiUrl) {
        this.cache = Caches.builder((String)CACHE_NAME, (CacheEntryFactory)new WebsiteLookupEntryFactory(goApiUrl), (Caches.CacheStrategy)Caches.CacheStrategy.CaffeineIfAvailable).expireAfterWrite(DEFAULT_CACHE_TIMEOUT).maximumSize(1000L).build();
    }

    @Override
    public String getWebsiteForDepartmentCode(String code) {
        if (!StringUtils.hasText((String)code)) {
            return null;
        }
        code = code.toLowerCase().trim();
        try {
            return (String)((Object)this.cache.get((Serializable)((Object)code)));
        }
        catch (CacheEntryUpdateException e) {
            LOGGER.error("Exception getting departmental website; returning null for now (but not storing null)");
            return null;
        }
    }

    public static final class WebsiteLookupEntryFactory
    extends SingularCacheEntryFactory<String, String> {
        private final Uri apiUrl;

        public WebsiteLookupEntryFactory(Uri goApiUrl) {
            this.apiUrl = goApiUrl;
        }

        public String create(String code) throws CacheEntryUpdateException {
            String goPath = "dep-code-" + code;
            SimpleHttpMethodExecutor ex = new SimpleHttpMethodExecutor(HttpMethodExecutor.Method.get);
            ex.setUrl(new UriBuilder(this.apiUrl).addQueryParameter("path", goPath).toUri());
            try {
                Pair response = ex.execute(HttpMethodExecutor.RESPONSE_AS_STRING);
                int statusCode = (Integer)response.getLeft();
                if (statusCode != 200) {
                    throw new CacheEntryUpdateException("Expected SC_OK but returned " + statusCode);
                }
                JSONObject obj = new JSONObject((String)response.getRight());
                boolean isFound = obj.getBoolean("found");
                if (isFound) {
                    JSONObject redirect = obj.getJSONObject("redirect");
                    return redirect.getString("target");
                }
                return null;
            }
            catch (Exception e) {
                throw new CacheEntryUpdateException((Throwable)e);
            }
        }

        public boolean shouldBeCached(String val) {
            return true;
        }
    }
}

