/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.lookup;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.warwick.util.AbstractJUnit4JettyTest;
import uk.ac.warwick.util.JettyServer;
import uk.ac.warwick.util.core.lookup.CachedTwitterTimelineFetcher;
import uk.ac.warwick.util.core.lookup.TwitterAuthenticationHttpRequestDecorator;
import uk.ac.warwick.util.httpclient.httpclient4.HttpRequestDecorator;
import uk.ac.warwick.util.web.Uri;

public final class CachedTwitterTimelineFetcherTest
extends AbstractJUnit4JettyTest {
    private static final String TEST_CONSUMER_KEY = "xvz1evFS4wEEPTGEFPHBog";
    private static final String TEST_CONSUMER_SECRET = "L8qq9PZyRg6ieKGEKhZolGC0vJWLw8iEJ88DRdyOg";

    @BeforeClass
    public static void startServers() throws Exception {
        CachedTwitterTimelineFetcherTest.startServer((Map)new HashMap<String, String>(){
            {
                this.put("/notfound.json", JettyServer.NotFoundServlet.class.getName());
                this.put("/twitter-down.json", JettyServer.ServiceUnavailableServlet.class.getName());
                this.put("/user_timeline.json", TwitterJSONServlet.class.getName());
                this.put("/oauth2token", OAuthTokenServlet.class.getName());
            }
        });
    }

    private TwitterAuthenticationHttpRequestDecorator authRequestDecorator(String consumerKey, String consumerSecret) {
        TwitterAuthenticationHttpRequestDecorator decorator = new TwitterAuthenticationHttpRequestDecorator(Uri.parse((String)(this.serverAddress + "oauth2token")));
        decorator.setConsumerKey(TEST_CONSUMER_KEY);
        decorator.setConsumerSecret(TEST_CONSUMER_SECRET);
        decorator.afterPropertiesSet();
        return decorator;
    }

    @Test
    public void found() throws Exception {
        CachedTwitterTimelineFetcher fetcher = new CachedTwitterTimelineFetcher(Uri.parse((String)(this.serverAddress + "user_timeline.json")));
        fetcher.setHttpRequestDecorator((HttpRequestDecorator)this.authRequestDecorator(TEST_CONSUMER_KEY, TEST_CONSUMER_SECRET));
        fetcher.afterPropertiesSet();
        int buffer = TwitterJSONServlet.executionCount;
        int oauthBuffer = OAuthTokenServlet.executionCount;
        Assert.assertEquals((Object)"{ \"success\": true }", (Object)fetcher.get("matmannion", 20, true, false).getResponseBody());
        Assert.assertEquals((long)1L, (long)(TwitterJSONServlet.executionCount - buffer));
        Assert.assertEquals((Object)"{ \"success\": true }", (Object)fetcher.get("matmannion", 20, true, false).getResponseBody());
        Assert.assertEquals((long)1L, (long)(TwitterJSONServlet.executionCount - buffer));
        Assert.assertEquals((Object)"{ \"success\": true }", (Object)fetcher.get("MatMannion", 20, true, false).getResponseBody());
        Assert.assertEquals((long)1L, (long)(TwitterJSONServlet.executionCount - buffer));
        Assert.assertEquals((long)1L, (long)(OAuthTokenServlet.executionCount - oauthBuffer));
    }

    @Test
    public void notFound() throws Exception {
        CachedTwitterTimelineFetcher fetcher = new CachedTwitterTimelineFetcher(Uri.parse((String)(this.serverAddress + "notfound.json")));
        fetcher.setHttpRequestDecorator((HttpRequestDecorator)this.authRequestDecorator(TEST_CONSUMER_KEY, TEST_CONSUMER_SECRET));
        fetcher.afterPropertiesSet();
        int buffer = JettyServer.NotFoundServlet.executionCount;
        int oauthBuffer = OAuthTokenServlet.executionCount;
        Assert.assertEquals((long)404L, (long)fetcher.get("notfound", 20, true, false).getStatusCode());
        Assert.assertEquals((long)1L, (long)(JettyServer.NotFoundServlet.executionCount - buffer));
        Assert.assertEquals((long)404L, (long)fetcher.get("notfound", 20, true, false).getStatusCode());
        Assert.assertEquals((long)1L, (long)(JettyServer.NotFoundServlet.executionCount - buffer));
        Assert.assertEquals((long)1L, (long)(OAuthTokenServlet.executionCount - oauthBuffer));
    }

    @Test
    public void twitterDown() throws Exception {
        CachedTwitterTimelineFetcher fetcher = new CachedTwitterTimelineFetcher(Uri.parse((String)(this.serverAddress + "twitter-down.json")));
        fetcher.setHttpRequestDecorator((HttpRequestDecorator)this.authRequestDecorator(TEST_CONSUMER_KEY, TEST_CONSUMER_SECRET));
        fetcher.afterPropertiesSet();
        int buffer = JettyServer.ServiceUnavailableServlet.executionCount;
        int oauthBuffer = OAuthTokenServlet.executionCount;
        Assert.assertEquals((long)503L, (long)fetcher.get("twitter-down", 20, true, false).getStatusCode());
        Assert.assertEquals((long)1L, (long)(JettyServer.ServiceUnavailableServlet.executionCount - buffer));
        Assert.assertEquals((long)503L, (long)fetcher.get("twitter-down", 20, true, false).getStatusCode());
        Assert.assertEquals((long)2L, (long)(JettyServer.ServiceUnavailableServlet.executionCount - buffer));
        Assert.assertEquals((long)1L, (long)(OAuthTokenServlet.executionCount - oauthBuffer));
    }

    public static class OAuthTokenServlet
    extends HttpServlet {
        private static int executionCount = 0;

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            Assert.assertEquals((Object)"Basic eHZ6MWV2RlM0d0VFUFRHRUZQSEJvZzpMOHFxOVBaeVJnNmllS0dFS2hab2xHQzB2SldMdzhpRUo4OERSZHlPZw==", (Object)req.getHeader("Authorization"));
            Assert.assertEquals((Object)"application/x-www-form-urlencoded;charset=UTF-8", (Object)req.getHeader("Content-Type"));
            Assert.assertEquals((Object)"client_credentials", (Object)req.getParameter("grant_type"));
            resp.setStatus(200);
            resp.getWriter().write("{\"token_type\":\"bearer\",\"access_token\":\"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA%2FAAAAAAAAAAAAAAAAAAAA%3DAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA\"}");
            ++executionCount;
        }
    }

    public static class TwitterJSONServlet
    extends HttpServlet {
        private static int executionCount = 0;

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            Assert.assertEquals((Object)"Bearer AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA%2FAAAAAAAAAAAAAAAAAAAA%3DAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", (Object)req.getHeader("Authorization"));
            Assert.assertEquals((Object)"matmannion", (Object)req.getParameter("screen_name"));
            Assert.assertEquals((Object)"40", (Object)req.getParameter("count"));
            Assert.assertEquals((Object)"true", (Object)req.getParameter("include_rts"));
            Assert.assertEquals((Object)"false", (Object)req.getParameter("exclude_replies"));
            Assert.assertNull((Object)req.getParameter("callback"));
            resp.setStatus(200);
            resp.getWriter().write("{ \"success\": true }");
            ++executionCount;
        }
    }
}

