/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.lookup;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import uk.ac.warwick.util.cache.Cache;
import uk.ac.warwick.util.cache.CacheEntryFactory;
import uk.ac.warwick.util.cache.CacheEntryUpdateException;
import uk.ac.warwick.util.cache.Caches;
import uk.ac.warwick.util.cache.SingularCacheEntryFactory;
import uk.ac.warwick.util.concurrency.promise.UnfulfilledPromiseException;
import uk.ac.warwick.util.concurrency.promise.WriteOncePromise;
import uk.ac.warwick.util.core.lookup.TwitterTimelineFetcher;
import uk.ac.warwick.util.core.lookup.TwitterTimelineResponse;
import uk.ac.warwick.util.httpclient.httpclient4.HttpMethodExecutor;
import uk.ac.warwick.util.httpclient.httpclient4.HttpRequestDecorator;
import uk.ac.warwick.util.httpclient.httpclient4.SimpleHttpMethodExecutor;
import uk.ac.warwick.util.web.Uri;
import uk.ac.warwick.util.web.UriBuilder;

public final class CachedTwitterTimelineFetcher
implements TwitterTimelineFetcher,
InitializingBean {
    public static final String CACHE_NAME = "TwitterTimelineCache";
    public static final Duration DEFAULT_CACHE_TIMEOUT = Duration.ofHours(1L);
    private static final int TWEET_COUNT_PADDING = 20;
    private static final Uri DEFAULT_BASE_URL = Uri.parse((String)"https://api.twitter.com/1.1/statuses/user_timeline.json");
    private final Uri baseUri;
    private final WriteOncePromise<Cache<Uri, TwitterTimelineResponse>> cache = new WriteOncePromise();
    private HttpRequestDecorator httpRequestDecorator;

    public CachedTwitterTimelineFetcher() {
        this(DEFAULT_BASE_URL);
    }

    CachedTwitterTimelineFetcher(Uri theBaseUri) {
        this.baseUri = theBaseUri;
    }

    @Override
    public TwitterTimelineResponse get(String accountName, int num, boolean includeRetweets, boolean excludeReplies) throws CacheEntryUpdateException {
        this.initialiseCache();
        UriBuilder uri = new UriBuilder(this.baseUri);
        uri.addQueryParameter("screen_name", accountName.toLowerCase());
        uri.addQueryParameter("count", Integer.toString(num + 20));
        uri.addQueryParameter("include_rts", Boolean.toString(includeRetweets));
        uri.addQueryParameter("exclude_replies", Boolean.toString(excludeReplies));
        try {
            return (TwitterTimelineResponse)((Cache)this.cache.fulfilPromise()).get((Serializable)uri.toUri());
        }
        catch (UnfulfilledPromiseException e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized void initialiseCache() {
        if (this.cache.isWritten()) {
            return;
        }
        this.cache.setValue((Object)Caches.builder((String)CACHE_NAME, (CacheEntryFactory)new TwitterTimelineEntryFactory(this.httpRequestDecorator), (Caches.CacheStrategy)Caches.CacheStrategy.CaffeineIfAvailable).expireAfterWrite(DEFAULT_CACHE_TIMEOUT).maximumSize(1000L).build());
    }

    public HttpRequestDecorator getHttpRequestDecorator() {
        return this.httpRequestDecorator;
    }

    public void setHttpRequestDecorator(HttpRequestDecorator httpRequestDecorator) {
        this.httpRequestDecorator = httpRequestDecorator;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.httpRequestDecorator, (String)"httpRequestDecorator must be set! (see TwitterAuthenticationHttpRequestDecorator)");
    }

    private static final class TwitterTimelineEntryFactory
    extends SingularCacheEntryFactory<Uri, TwitterTimelineResponse> {
        private final HttpRequestDecorator httpRequestDecorator;

        private TwitterTimelineEntryFactory(HttpRequestDecorator decorator) {
            this.httpRequestDecorator = decorator;
        }

        public TwitterTimelineResponse create(Uri uri) throws CacheEntryUpdateException {
            SimpleHttpMethodExecutor executor = new SimpleHttpMethodExecutor(HttpMethodExecutor.Method.get);
            executor.setUrl(uri);
            executor.setHttpRequestDecorator(this.httpRequestDecorator);
            try {
                return (TwitterTimelineResponse)executor.execute(resp -> new TwitterTimelineResponse(EntityUtils.toString((HttpEntity)resp.getEntity()), resp.getStatusLine().getStatusCode(), resp.getAllHeaders())).getRight();
            }
            catch (IOException e) {
                throw new CacheEntryUpdateException((Throwable)e);
            }
        }

        public boolean shouldBeCached(TwitterTimelineResponse entry) {
            return entry.getStatusCode() != 503;
        }
    }
}

