/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.lookup.departments;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.cache.Cache;
import uk.ac.warwick.util.cache.CacheEntryFactory;
import uk.ac.warwick.util.cache.CacheEntryUpdateException;
import uk.ac.warwick.util.cache.Caches;
import uk.ac.warwick.util.core.lookup.DepartmentNameLookup;
import uk.ac.warwick.util.core.lookup.departments.Department;
import uk.ac.warwick.util.core.lookup.departments.DepartmentLookup;
import uk.ac.warwick.util.core.lookup.departments.FacultyLookup;
import uk.ac.warwick.util.core.lookup.departments.FacultyLookupImpl;
import uk.ac.warwick.util.core.lookup.departments.Utils;
import uk.ac.warwick.util.httpclient.httpclient4.HttpMethodExecutor;
import uk.ac.warwick.util.httpclient.httpclient4.SimpleHttpMethodExecutor;
import uk.ac.warwick.util.web.Uri;

public class DepartmentLookupImpl
implements DepartmentLookup,
CacheEntryFactory<String, LinkedHashMap<String, Department>>,
DepartmentNameLookup {
    private static final String CACHE_NAME = "departments";
    private static final String DEPTS_KEY = "all.departments";
    private static final Duration CACHE_EXPIRY = Duration.ofDays(7L);
    private static final Logger LOGGER = LoggerFactory.getLogger(DepartmentLookupImpl.class);
    private static final Uri DEFAULT_DEPARTMENTS_API_URL = Uri.parse((String)"https://departments.warwick.ac.uk/public/api/department.json");
    private static final Uri DEFAULT_FACULTY_API_URL = Uri.parse((String)"https://departments.warwick.ac.uk/public/api/faculty.json");
    static final String ACADEMIC = "ACADEMIC";
    static final String RESERVED = "RESERVED";
    static final String SERVICE = "SERVICE";
    static final String SELF_FINANCING = "SELF_FINANCING";
    private final Cache<String, LinkedHashMap<String, Department>> cache;
    private final String url;
    private final FacultyLookup facultyLookup;

    public DepartmentLookupImpl() {
        this(DEFAULT_DEPARTMENTS_API_URL.toString(), DEFAULT_FACULTY_API_URL.toString());
    }

    public DepartmentLookupImpl(String url, String facultyUrl) {
        this.url = url;
        this.facultyLookup = new FacultyLookupImpl(facultyUrl);
        this.cache = Caches.builder((String)CACHE_NAME, (CacheEntryFactory)this, (Caches.CacheStrategy)Caches.CacheStrategy.CaffeineIfAvailable).expireAfterWrite(CACHE_EXPIRY).maximumSize(100L).build();
        this.getDepartment("IN");
    }

    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public Department getDepartment(String code) {
        if (code == null) {
            return null;
        }
        try {
            return (Department)((LinkedHashMap)this.cache.get((Serializable)((Object)DEPTS_KEY))).get(code.toUpperCase());
        }
        catch (CacheEntryUpdateException e) {
            LOGGER.error("Error updating cache, trying to fetch key " + code, (Throwable)e);
            return null;
        }
    }

    @Override
    public List<Department> getAllDepartments() {
        try {
            return new ArrayList<Department>(((LinkedHashMap)this.cache.get((Serializable)((Object)DEPTS_KEY))).values());
        }
        catch (CacheEntryUpdateException e) {
            LOGGER.error("Error updating cache, trying to fetch all entries", (Throwable)e);
            return null;
        }
    }

    private Set<Department> filterDepartments(String deptType) {
        List<Department> allDepts = this.getAllDepartments();
        HashSet<Department> filteredDepts = new HashSet<Department>();
        for (Department d : allDepts) {
            if (!d.getType().equals(deptType)) continue;
            filteredDepts.add(d);
        }
        return filteredDepts;
    }

    @Override
    public Set<Department> getAllAcademicDepartments() {
        return this.filterDepartments(ACADEMIC);
    }

    @Override
    public Set<Department> getAllServiceDepartments() {
        return this.filterDepartments(SERVICE);
    }

    @Override
    public Set<Department> getAllAdminDepartments() {
        return this.filterDepartments(RESERVED);
    }

    @Override
    public Set<Department> getAllSelfFundingDepartments() {
        return this.filterDepartments(SELF_FINANCING);
    }

    private Department parseJsonToDepartment(JSONObject json) throws JSONException {
        Department d = new Department();
        d.setCode(json.getString("code"));
        d.setName(json.getString("name"));
        d.setShortName(json.getString("shortName"));
        d.setType(json.getString("type"));
        d.setCurrent(json.getBoolean("inUse"));
        d.setLastModified(Utils.getLastModified(json));
        d.setFaculty(this.facultyLookup.getFaculty(json.getString("faculty")));
        return d;
    }

    public LinkedHashMap<String, Department> create(String ignored) throws CacheEntryUpdateException {
        HttpGet get = new HttpGet(this.url);
        try {
            LOGGER.info("Updating departments from " + this.url);
            return (LinkedHashMap)new SimpleHttpMethodExecutor(HttpMethodExecutor.Method.get, this.url).execute((ResponseHandler)new ResponseHandler<LinkedHashMap<String, Department>>(){

                public LinkedHashMap<String, Department> handleResponse(HttpResponse response) throws IOException {
                    HttpEntity entity = response.getEntity();
                    try {
                        JSONArray jsonDepartments = new JSONArray(EntityUtils.toString((HttpEntity)entity));
                        ArrayList<Department> departments = new ArrayList<Department>();
                        for (int i = 0; i < jsonDepartments.length(); ++i) {
                            JSONObject jsonDepartment = jsonDepartments.getJSONObject(i);
                            Department department = DepartmentLookupImpl.this.parseJsonToDepartment(jsonDepartment);
                            departments.add(department);
                        }
                        Collections.sort(departments);
                        LinkedHashMap<String, Department> departmentsMap = new LinkedHashMap<String, Department>();
                        for (Department department : departments) {
                            departmentsMap.put(department.getCode(), department);
                        }
                        return departmentsMap;
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
            }).getRight();
        }
        catch (IOException e) {
            LOGGER.error("Unable to fetch department information from " + get.getURI().toString(), (Object)e.getMessage());
            throw new CacheEntryUpdateException((Throwable)e);
        }
    }

    public Map<String, LinkedHashMap<String, Department>> create(List<String> keys) throws CacheEntryUpdateException {
        throw new CacheEntryUpdateException("Unsupported cache operation");
    }

    public boolean isSupportsMultiLookups() {
        return false;
    }

    public boolean shouldBeCached(LinkedHashMap<String, Department> val) {
        return true;
    }

    @Override
    public String getNameForDepartmentCode(String code) {
        Department department = this.getDepartment(code);
        if (department != null) {
            return department.getName();
        }
        return null;
    }
}

