/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.lookup.departments;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.warwick.util.core.lookup.departments.Faculty;
import uk.ac.warwick.util.core.lookup.departments.FacultyLookupImpl;

public class FacultyLookupTest {
    private FacultyLookupImpl facultyLookup;

    @Before
    public void setUp() {
        this.facultyLookup = new FacultyLookupImpl("https://departments.warwick.ac.uk/public/api/faculty.json");
    }

    @Test
    public void testGetFaculty() throws Exception {
        Faculty f = this.facultyLookup.getFaculty("X");
        Assert.assertEquals((Object)"X", (Object)f.getCode());
        Assert.assertEquals((Object)"Administration and Service", (Object)f.getName());
        Assert.assertEquals((Object)true, (Object)f.isCurrent());
        Assert.assertNotNull((Object)f.getLastModified());
    }

    @Test
    public void testGetNonExistentFaculty() throws Exception {
        Faculty f = this.facultyLookup.getFaculty("HERONZ");
        Assert.assertNull((Object)f);
    }

    @Test
    public void testGetNullFaculty() throws Exception {
        Faculty f = this.facultyLookup.getFaculty(null);
        Assert.assertNull((Object)f);
    }

    @Test
    public void testGetAllFaculties() throws Exception {
        List allFaculties = this.facultyLookup.getAllFaculties();
        Assert.assertFalse((boolean)allFaculties.isEmpty());
        Faculty lastFaculty = null;
        for (Faculty f : allFaculties) {
            if (lastFaculty != null) {
                Assert.assertTrue((lastFaculty.compareTo(f) <= 0 ? 1 : 0) != 0);
            }
            lastFaculty = f;
        }
    }

    @Test
    public void testGetFacultyWithBadSource() throws Exception {
        this.facultyLookup = new FacultyLookupImpl("https://websignon-test.warwick.ac.uk/faculty.json");
        this.facultyLookup.clearCache();
        Assert.assertNull((Object)this.facultyLookup.getFaculty("IN"));
        Assert.assertNull((Object)this.facultyLookup.getAllFaculties());
    }
}

