/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.lookup;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.warwick.util.AbstractJUnit4JettyTest;
import uk.ac.warwick.util.JettyServer;
import uk.ac.warwick.util.core.lookup.GoWarwickDepartmentWebsiteLookup;
import uk.ac.warwick.util.web.Uri;

public final class GoWarwickDepartmentWebsiteLookupTest
extends AbstractJUnit4JettyTest {
    @BeforeClass
    public static void startServers() throws Exception {
        GoWarwickDepartmentWebsiteLookupTest.startServer((Map)new HashMap<String, String>(){
            {
                this.put("/404", JettyServer.NotFoundServlet.class.getName());
                this.put("/found", RedirectFoundServlet.class.getName());
                this.put("/not-found", RedirectNotFoundServlet.class.getName());
                this.put("/invalid-json", InvalidJSONServlet.class.getName());
            }
        });
    }

    @Test
    public void found() {
        GoWarwickDepartmentWebsiteLookup lookup = new GoWarwickDepartmentWebsiteLookup(Uri.parse((String)(this.serverAddress + "found")));
        Assert.assertEquals((Object)"http://www2.warwick.ac.uk/services/its", (Object)lookup.getWebsiteForDepartmentCode("IN"));
        Assert.assertEquals((Object)"http://www2.warwick.ac.uk/services/its", (Object)lookup.getWebsiteForDepartmentCode("IN"));
    }

    @Test
    public void notFound() {
        GoWarwickDepartmentWebsiteLookup lookup = new GoWarwickDepartmentWebsiteLookup(Uri.parse((String)(this.serverAddress + "not-found")));
        Assert.assertNull((Object)lookup.getWebsiteForDepartmentCode("NF"));
        Assert.assertNull((Object)lookup.getWebsiteForDepartmentCode("NF"));
    }

    @Test
    public void invalid() {
        GoWarwickDepartmentWebsiteLookup lookup = new GoWarwickDepartmentWebsiteLookup(Uri.parse((String)(this.serverAddress + "invalid-json")));
        Assert.assertNull((Object)lookup.getWebsiteForDepartmentCode("IV"));
        Assert.assertNull((Object)lookup.getWebsiteForDepartmentCode("IV"));
    }

    @Test
    public void fourOhFour() {
        GoWarwickDepartmentWebsiteLookup lookup = new GoWarwickDepartmentWebsiteLookup(Uri.parse((String)(this.serverAddress + "404")));
        Assert.assertNull((Object)lookup.getWebsiteForDepartmentCode("FO"));
        Assert.assertNull((Object)lookup.getWebsiteForDepartmentCode("FO"));
    }

    public static class InvalidJSONServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
            resp.getWriter().write("Error 500 Something has gone horribly wrong. OH BUT WE RETURNED A 200 OH WELL");
        }
    }

    public static class RedirectNotFoundServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
            resp.getWriter().write("{ found: false }");
        }
    }

    public static class RedirectFoundServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            Assert.assertEquals((Object)"dep-code-in", (Object)req.getParameter("path"));
            resp.setStatus(200);
            resp.getWriter().write("{ found: true , redirect: { path: \"dep-code-in\" , internal: true , target: \"http://www2.warwick.ac.uk/services/its\" , enabled: true , approved: true } }");
        }
    }
}

