/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.httpclient.httpclient4;

import java.net.ProxySelector;
import java.nio.charset.StandardCharsets;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import uk.ac.warwick.util.httpclient.httpclient4.HttpClientFactory;

public final class MultiThreadedHttpClientFactory
implements HttpClientFactory {
    public static final RequestConfig DEFAULT_REQUEST_CONFIG = RequestConfig.custom().setConnectTimeout(30000).setSocketTimeout(30000).setExpectContinueEnabled(true).setCircularRedirectsAllowed(true).setRedirectsEnabled(true).setMaxRedirects(10).build();
    private static final MultiThreadedHttpClientFactory INSTANCE = new MultiThreadedHttpClientFactory();
    private final HttpClient client;
    private final PoolingHttpClientConnectionManager connectionManager;

    public MultiThreadedHttpClientFactory() {
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setBufferSize(8192).setCharset(StandardCharsets.UTF_8).build();
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(5);
        this.connectionManager = connectionManager;
        this.client = HttpClientBuilder.create().setDefaultConnectionConfig(connectionConfig).setDefaultRequestConfig(DEFAULT_REQUEST_CONFIG).setDefaultSocketConfig(socketConfig).setUserAgent("WarwickUtils HttpMethodExecutor, elab@warwick.ac.uk").setConnectionManager((HttpClientConnectionManager)connectionManager).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(1, false)).setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault())).build();
    }

    @Override
    public HttpClient getClient() {
        return this.client;
    }

    public PoolingHttpClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public static MultiThreadedHttpClientFactory getInstance() {
        return INSTANCE;
    }
}

