/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.httpclient.httpclient4;

import java.net.URI;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.HttpContext;
import uk.ac.warwick.sso.client.SSOProxyCookieHelper;
import uk.ac.warwick.userlookup.User;
import uk.ac.warwick.util.httpclient.WarwickTagUrlMangler;
import uk.ac.warwick.util.httpclient.httpclient4.AbstractHttpMethodExecutor;
import uk.ac.warwick.util.httpclient.httpclient4.HttpMethodExecutor;
import uk.ac.warwick.util.httpclient.httpclient4.HttpRequestDecorator;
import uk.ac.warwick.util.web.Uri;

public abstract class AbstractWarwickAwareHttpMethodExecutor
extends AbstractHttpMethodExecutor {
    private static final long serialVersionUID = -2713163190560555670L;
    private boolean setCookie;
    private boolean substituteTags;
    private final User user;

    public AbstractWarwickAwareHttpMethodExecutor(HttpMethodExecutor.Method method, Uri requestUrl, String theCookieDomain, User user) {
        super(method, requestUrl);
        this.user = user;
        super.setHttpRequestDecorator(new WarwickAwareHttpRequestDecorator(theCookieDomain, user));
    }

    public AbstractWarwickAwareHttpMethodExecutor(HttpMethodExecutor.Method method, String requestUrl, String theCookieDomain, User user) {
        this(method, AbstractWarwickAwareHttpMethodExecutor.parse(requestUrl), theCookieDomain, user);
    }

    final boolean isSetCookie() {
        return this.setCookie;
    }

    final boolean isSubstituteTags() {
        return this.substituteTags;
    }

    @Override
    public final void setSSOCookie(boolean cookie) {
        this.setCookie = cookie;
    }

    @Override
    public final void setSubstituteWarwickTags(boolean substituteWarwickTags) {
        this.substituteTags = substituteWarwickTags;
    }

    @Override
    public Uri parseRequestUrl(Uri requestUrl) {
        return this.substituteWarwickTags(requestUrl);
    }

    private Uri substituteWarwickTags(Uri input) {
        if (this.isSubstituteTags()) {
            return new WarwickTagUrlMangler().substituteWarwickTags(input, this.user, this.shouldAllowWarwickToken(input));
        }
        return input;
    }

    protected abstract boolean shouldAllowWarwickToken(Uri var1);

    private static Uri substituted(Uri input, User user) {
        return new WarwickTagUrlMangler().substituteWarwickTags(input, user, false);
    }

    private class WarwickAwareHttpRequestDecorator
    implements HttpRequestDecorator {
        private final User user;
        private final String cookieDomain;

        public WarwickAwareHttpRequestDecorator(String theCookieDomain, User user) {
            this.cookieDomain = theCookieDomain;
            this.user = user;
        }

        @Override
        public void decorate(HttpUriRequest request, HttpContext context) {
            if (this.isWarwickServer(AbstractWarwickAwareHttpMethodExecutor.this.getUrl()) && this.user.isLoggedIn() && AbstractWarwickAwareHttpMethodExecutor.this.isSetCookie()) {
                request.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
                Uri targetUri = Uri.fromJavaUri((URI)request.getURI());
                BasicCookieStore store = new BasicCookieStore();
                Cookie proxyCookie = new SSOProxyCookieHelper().getProxyHttpClientCookie(targetUri.toJavaUrl(), this.user);
                store.addCookie(proxyCookie);
                BasicClientCookie ssoCookie = new BasicClientCookie("WarwickSSO", this.user.getOldWarwickSSOToken());
                ssoCookie.setDomain(this.cookieDomain);
                ssoCookie.setAttribute("domain", this.cookieDomain);
                ssoCookie.setPath("/");
                store.addCookie((Cookie)ssoCookie);
                context.setAttribute("http.cookie-store", (Object)store);
            }
        }

        private boolean isWarwickServer(String theUrl) {
            return theUrl.indexOf("warwick.ac.uk") > -1 || theUrl.indexOf("137.205") > -1;
        }
    }
}

