/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.httpclient;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import uk.ac.warwick.userlookup.User;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.web.Uri;
import uk.ac.warwick.util.web.UriBuilder;

public class WarwickTagUrlMangler {
    public final String substituteWarwickTags(String stringToSubstitute, User user, boolean allowToken) {
        stringToSubstitute = this.doStringReplace(stringToSubstitute, "<warwick_username/>", user.getFullName());
        stringToSubstitute = this.doStringReplace(stringToSubstitute, "<warwick_username/>", user.getFullName());
        stringToSubstitute = this.doStringReplace(stringToSubstitute, "<warwick_userid/>", user.getUserId());
        stringToSubstitute = this.doStringReplace(stringToSubstitute, "<warwick_useremail/>", user.getEmail());
        if (allowToken) {
            stringToSubstitute = this.doStringReplace(stringToSubstitute, "<warwick_token/>", user.getOldWarwickSSOToken());
        }
        stringToSubstitute = this.doStringReplace(stringToSubstitute, "<warwick_idnumber/>", user.getWarwickId());
        stringToSubstitute = this.doStringReplace(stringToSubstitute, "<warwick_deptcode/>", user.getDepartmentCode());
        return stringToSubstitute;
    }

    private String doStringReplace(String string, String token, String value) {
        string = this.replace(string, token, value);
        string = this.replace(string, token.replace("<", "%3C").replace(">", "%3E").replace("/", "%2F"), value);
        string = this.replace(string, token.replace("<", "%3C").replace(">", "%3E"), value);
        return string;
    }

    public final Uri substituteWarwickTags(Uri urlToSubstitute, User user, boolean allowToken) {
        return this.substituteWarwickTags(new UriBuilder(urlToSubstitute), user, allowToken).toUri();
    }

    public final UriBuilder substituteWarwickTags(UriBuilder builder, User user, boolean allowToken) {
        this.replaceAndEncode(builder, "<warwick_username/>", user.getFullName());
        this.replaceAndEncode(builder, "<warwick_userid/>", user.getUserId());
        this.replaceAndEncode(builder, "<warwick_useremail/>", user.getEmail());
        if (allowToken) {
            this.replaceAndEncode(builder, "<warwick_token/>", user.getOldWarwickSSOToken());
        }
        this.replaceAndEncode(builder, "<warwick_idnumber/>", user.getWarwickId());
        this.replaceAndEncode(builder, "<warwick_deptcode/>", user.getDepartmentCode());
        return builder;
    }

    private void replaceAndEncode(UriBuilder builder, String token, String value) {
        this.replaceAndEncodeToken(builder, token, value);
        this.replaceAndEncodeToken(builder, token.replace("<", "%3C").replace(">", "%3E").replace("/", "%2F"), value);
        this.replaceAndEncodeToken(builder, token.replace("<", "%3C").replace(">", "%3E"), value);
    }

    private void replaceAndEncodeToken(UriBuilder builder, String token, String value) {
        String path = builder.getPath();
        if (path.indexOf(token) != -1) {
            builder.setPath(this.replace(path, token, value));
        }
        for (Map.Entry param : Sets.newHashSet(builder.getQueryParameters().entrySet())) {
            boolean hasChanged = false;
            ArrayList newValues = Lists.newArrayList();
            for (String paramValue : (List)param.getValue()) {
                if (paramValue.indexOf(token) != -1) {
                    hasChanged = true;
                    newValues.add(this.replace(paramValue, token, value));
                    continue;
                }
                newValues.add(paramValue);
            }
            if (hasChanged) {
                builder.putQueryParameter((String)param.getKey(), (Iterable)newValues);
            }
            if (((String)param.getKey()).indexOf(token) == -1) continue;
            String newKey = this.replace((String)param.getKey(), token, value);
            builder.getQueryParameters().remove(param.getKey());
            for (String v : newValues) {
                builder.addQueryParameter(newKey, v);
            }
        }
    }

    private String replace(String str, String token, String value) {
        return str.replace(token, StringUtils.hasLength((String)value) ? value : "");
    }
}

