/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.httpclient.httpclient4;

import com.google.common.collect.ImmutableMap;
import java.net.SocketTimeoutException;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.warwick.util.AbstractJUnit4JettyTest;
import uk.ac.warwick.util.JettyServer;
import uk.ac.warwick.util.collections.Pair;
import uk.ac.warwick.util.httpclient.httpclient4.HttpMethodExecutor;
import uk.ac.warwick.util.httpclient.httpclient4.SimpleHttpMethodExecutor;

public class SimpleHttpMethodExecutorTest
extends AbstractJUnit4JettyTest {
    @BeforeClass
    public static void letsGetItStarted() throws Exception {
        SimpleHttpMethodExecutorTest.startServer((Map)ImmutableMap.builder().put((Object)"/website", (Object)JettyServer.OKServlet.class.getName()).put((Object)"/longop", (Object)JettyServer.SlowServlet.class.getName()).build());
    }

    @Test
    public void testItWorks() throws Exception {
        SimpleHttpMethodExecutor ex = new SimpleHttpMethodExecutor(HttpMethodExecutor.Method.get);
        ex.setUrl(this.serverAddress + "/website");
        Pair result = ex.execute(HttpMethodExecutor.RESPONSE_AS_BYTES);
        Assert.assertEquals((Object)"/website", (Object)ex.getUri().getPath());
        Assert.assertEquals((long)200L, (long)((Integer)result.getLeft()).intValue());
        Assert.assertNotNull((Object)result.getRight());
    }

    @Test(expected=SocketTimeoutException.class)
    public void timeout() throws Exception {
        SimpleHttpMethodExecutorTest.startServer((Map)ImmutableMap.of((Object)"/longop", (Object)JettyServer.SlowServlet.class.getName()));
        SimpleHttpMethodExecutor ex = new SimpleHttpMethodExecutor(HttpMethodExecutor.Method.get);
        ex.setUrl(this.serverAddress + "/longop");
        ex.setConnectionTimeout(10);
        ex.setRetrievalTimeout(10);
        ex.execute(HttpMethodExecutor.RESPONSE_AS_STRING);
    }

    @Test
    public void testUnsupportedOperation() throws Exception {
        SimpleHttpMethodExecutor ex = new SimpleHttpMethodExecutor(HttpMethodExecutor.Method.head);
        ex.setUrl(this.serverAddress + "/website");
        try {
            ex.setHttpClientFactoryStrategyAsString("always");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ex.setSSOCookie(true);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

