/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.httpclient.httpclient4;

import java.io.IOException;
import junit.framework.TestCase;
import uk.ac.warwick.userlookup.User;
import uk.ac.warwick.util.collections.Pair;
import uk.ac.warwick.util.httpclient.httpclient4.HttpMethodExecutor;
import uk.ac.warwick.util.httpclient.httpclient4.SimpleHttpMethodExecutor;
import uk.ac.warwick.util.httpclient.httpclient4.WebServiceHttpMethodExecutor;

public final class QueryStringEscapingTest
extends TestCase {
    private void retrieveUrl(String url) throws IOException {
        SimpleHttpMethodExecutor ex = new SimpleHttpMethodExecutor(HttpMethodExecutor.Method.get, url);
        ex.setConnectionTimeout(500);
        Pair status = ex.execute(HttpMethodExecutor.RESPONSE_AS_STRING);
        QueryStringEscapingTest.assertTrue((String)("Should be able to access " + url + "(" + status.getLeft() + ")"), ((Integer)status.getLeft() < 500 ? 1 : 0) != 0);
        QueryStringEscapingTest.assertNotNull((Object)status.getRight());
    }

    public void testEscapeAngleBrackets() throws Exception {
        String url = "http://www2.warwick.ac.uk/insite/?query=<value/>";
        this.retrieveUrl(url);
    }

    public void testWarwickTagReplacement() throws Exception {
        String url = "http://www2.warwick.ac.uk/insite/?dept=<warwick_deptcode/>";
        User user = new User();
        user.setDepartmentCode("IN");
        WebServiceHttpMethodExecutor ex = new WebServiceHttpMethodExecutor(HttpMethodExecutor.Method.get, url, ".warwick.ac.uk", user);
        ex.setSubstituteWarwickTags(true);
        Pair status = ex.execute(HttpMethodExecutor.RESPONSE_AS_STRING);
        QueryStringEscapingTest.assertEquals((int)200, (int)((Integer)status.getLeft()));
        QueryStringEscapingTest.assertEquals((String)"https://warwick.ac.uk/insite/?dept=IN", (String)ex.getRedirectUrl());
        QueryStringEscapingTest.assertNotNull((Object)status.getRight());
    }

    public void testWarwickTagReplacementInPath() throws Exception {
        String url = "http://www2.warwick.ac.uk/<warwick_deptcode/>/";
        User user = new User();
        user.setDepartmentCode("insite");
        WebServiceHttpMethodExecutor ex = new WebServiceHttpMethodExecutor(HttpMethodExecutor.Method.get, url, ".warwick.ac.uk", user);
        ex.setSubstituteWarwickTags(true);
        Pair status = ex.execute(HttpMethodExecutor.RESPONSE_AS_STRING);
        QueryStringEscapingTest.assertEquals((String)("Should be able to access " + url), (int)200, (int)((Integer)status.getLeft()));
        QueryStringEscapingTest.assertEquals((String)"https://warwick.ac.uk/insite/", (String)ex.getRedirectUrl());
        QueryStringEscapingTest.assertNotNull((Object)status.getRight());
    }
}

