/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.httpclient;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.userlookup.User;
import uk.ac.warwick.util.httpclient.WarwickTagUrlMangler;
import uk.ac.warwick.util.web.Uri;

public class WarwickTagUrlManglerTest {
    @Test
    public void departmentCodeTag() {
        WarwickTagUrlMangler mangler = new WarwickTagUrlMangler();
        String testUrl = "http://www2.warwick.ac.uk/foo/<warwick_deptcode/>/bar";
        User u = new User();
        Assert.assertEquals((Object)"http://www2.warwick.ac.uk/foo//bar", (Object)mangler.substituteWarwickTags(Uri.parse((String)testUrl), u, false).toString());
        u.setDepartmentCode("IN");
        Assert.assertEquals((Object)"http://www2.warwick.ac.uk/foo/IN/bar", (Object)mangler.substituteWarwickTags(Uri.parse((String)testUrl), u, false).toString());
    }

    @Test
    public void everythingEver() {
        WarwickTagUrlMangler mangler = new WarwickTagUrlMangler();
        User u = new User();
        u.setFirstName("Fred");
        u.setLastName("Test");
        u.setDepartmentCode("IN");
        u.setUserId("AUserId");
        u.setEmail("somewhere@something");
        u.setWarwickId("123WarwickID");
        String testUrl = "http://www.warwick.ac.uk/?yes=<warwick_username/>|<warwick_userid/>|<warwick_useremail/>|<warwick_token/>|<warwick_idnumber/>|<warwick_deptcode/>";
        String result = "http://www.warwick.ac.uk/?yes=Fred+Test%7CAUserId%7Csomewhere%40something%7C%3Cwarwick_token%2F%3E%7C123WarwickID%7CIN";
        Assert.assertEquals((Object)result, (Object)mangler.substituteWarwickTags(Uri.parse((String)testUrl), u, false).toString());
    }

    @Test
    public void tokenForWhitelistedPage() {
        WarwickTagUrlMangler mangler = new WarwickTagUrlMangler();
        User u = new User();
        u.setToken("tok");
        String testUrl = "http://www.eng.warwick.ac.uk/legacy?token=<warwick_token/>";
        String result = "http://www.eng.warwick.ac.uk/legacy?token=tok";
        Assert.assertEquals((Object)result, (Object)mangler.substituteWarwickTags(Uri.parse((String)testUrl), u, true).toString());
    }

    @Test
    public void plainTextReplacement() {
        User u = new User();
        WarwickTagUrlMangler mangler = new WarwickTagUrlMangler();
        Assert.assertEquals((Object)"don't change my spaces to %20", (Object)mangler.substituteWarwickTags("don't change my spaces to %20", u, false));
        Assert.assertEquals((Object)"here is a ", (Object)mangler.substituteWarwickTags("here is a <warwick_deptcode/>", u, false));
        u.setDepartmentCode("IN");
        Assert.assertEquals((Object)"here is a IN", (Object)mangler.substituteWarwickTags("here is a <warwick_deptcode/>", u, false));
    }
}

