/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.hibernate4;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.StringType;
import org.hibernate.usertype.UserType;

public final class OracleEmptyStringUserType
implements UserType {
    public static final OracleEmptyStringUserType INSTANCE = new OracleEmptyStringUserType();
    public static final String MARK_EMPTY = "<EmptyString/>";
    private static final int[] TYPES = new int[]{12};

    public int[] sqlTypes() {
        return TYPES;
    }

    public Class<String> returnedClass() {
        return String.class;
    }

    public boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public Object deepCopy(Object x) {
        return x;
    }

    public boolean isMutable() {
        return false;
    }

    public String nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        String dbValue = (String)StringType.INSTANCE.nullSafeGet(rs, names[0], session);
        if (dbValue != null) {
            return this.unescape(dbValue);
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value != null) {
            String v = this.escape(value.toString());
            StringType.INSTANCE.nullSafeSet(st, (Object)v, index, session);
        } else {
            StringType.INSTANCE.nullSafeSet(st, null, index, session);
        }
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Serializable disassemble(Object value) {
        return (Serializable)this.deepCopy(value);
    }

    private String escape(String string) {
        return string == null || string.length() == 0 ? MARK_EMPTY : string;
    }

    private String unescape(String string) throws HibernateException {
        if (string == null || MARK_EMPTY.equals(string)) {
            return "";
        }
        return string;
    }

    public int hashCode(Object string) throws HibernateException {
        return string.hashCode();
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }
}

