/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.hibernate4;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.hibernate4.EnumUserType;

public abstract class AbstractEnumUserTypeTest<E extends Enum<E>> {
    private final Mockery m = new JUnit4Mockery();

    protected abstract E[] values();

    protected abstract EnumUserType<E> getUserType();

    @Test
    public final void get() throws Exception {
        EnumUserType<E> type = this.getUserType();
        String columnName = "ENUM_VALUE";
        for (final Enum enumValue : this.values()) {
            final ResultSet rs = (ResultSet)this.m.mock(ResultSet.class, "rs_" + enumValue.name());
            this.m.checking((ExpectationBuilder)new Expectations(){
                {
                    ((ResultSet)this.one(rs)).getString("ENUM_VALUE");
                    this.will(1.returnValue((Object)enumValue.name()));
                }
            });
            Enum returnedValue = (Enum)type.nullSafeGet(rs, new String[]{"ENUM_VALUE"}, null, null);
            Assert.assertNotNull((Object)returnedValue);
            Assert.assertEquals((Object)enumValue, (Object)returnedValue);
            this.m.assertIsSatisfied();
        }
    }

    @Test
    public final void set() throws Exception {
        EnumUserType<E> type = this.getUserType();
        for (final Enum enumValue : this.values()) {
            final PreparedStatement st = (PreparedStatement)this.m.mock(PreparedStatement.class, "ps_" + enumValue.name());
            this.m.checking((ExpectationBuilder)new Expectations(){
                {
                    ((PreparedStatement)this.one(st)).setString(0, enumValue.name());
                }
            });
            type.nullSafeSet(st, (Object)enumValue, 0, null);
            this.m.assertIsSatisfied();
        }
    }

    @Test
    public final void getNull() throws Exception {
        EnumUserType<E> type = this.getUserType();
        String columnName = "ENUM_VALUE";
        final ResultSet rs = (ResultSet)this.m.mock(ResultSet.class, "rs");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((ResultSet)this.one(rs)).getString("ENUM_VALUE");
                this.will(3.returnValue(null));
            }
        });
        Enum returnedValue = (Enum)type.nullSafeGet(rs, new String[]{"ENUM_VALUE"}, null, null);
        Assert.assertNull((Object)returnedValue);
        this.m.assertIsSatisfied();
    }

    @Test
    public final void setNull() throws Exception {
        EnumUserType<E> type = this.getUserType();
        final PreparedStatement st = (PreparedStatement)this.m.mock(PreparedStatement.class, "ps");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((PreparedStatement)this.one(st)).setNull(0, 12);
            }
        });
        type.nullSafeSet(st, null, 0, null);
        this.m.assertIsSatisfied();
    }

    @Test
    public final void copy() throws Exception {
        EnumUserType<E> type = this.getUserType();
        for (Enum enumValue : this.values()) {
            Assert.assertEquals((Object)enumValue, (Object)type.deepCopy((Object)enumValue));
        }
        Assert.assertNull((Object)type.deepCopy(null));
    }

    @Test
    public final void equals() throws Exception {
        EnumUserType<E> type = this.getUserType();
        for (Enum enumValue : this.values()) {
            Assert.assertTrue((boolean)type.equals((Object)enumValue, (Object)enumValue));
            for (Enum otherValue : this.values()) {
                if (otherValue == enumValue) continue;
                Assert.assertFalse((boolean)type.equals((Object)enumValue, (Object)otherValue));
                Assert.assertFalse((boolean)type.equals((Object)otherValue, (Object)enumValue));
            }
            Assert.assertFalse((boolean)type.equals((Object)enumValue, null));
            Assert.assertFalse((boolean)type.equals(null, (Object)enumValue));
            Assert.assertTrue((boolean)type.equals(null, null));
        }
    }
}

