/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.hibernate4;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.hibernate4.UserTypeTestBase;
import uk.ac.warwick.util.hibernate4.YesNoNullableBooleanType;

public final class YesNoNullableBooleanTypeTest
extends UserTypeTestBase {
    @Test
    public void getYReturnsTrue() throws Exception {
        YesNoNullableBooleanType type = YesNoNullableBooleanType.INSTANCE;
        String columnName = "IS_TRUE";
        final ResultSet rs = (ResultSet)this.m.mock(ResultSet.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((ResultSet)this.one(rs)).getString("IS_TRUE");
                this.will(1.returnValue((Object)"Y"));
                ((ResultSet)this.one(rs)).wasNull();
                this.will(1.returnValue((Object)false));
            }
        });
        Boolean b = (Boolean)type.nullSafeGet(rs, "IS_TRUE", this.sessionImplementor);
        Assert.assertNotNull((Object)b);
        Assert.assertTrue((boolean)b);
        this.m.assertIsSatisfied();
    }

    @Test
    public void getNReturnsFalse() throws Exception {
        YesNoNullableBooleanType type = YesNoNullableBooleanType.INSTANCE;
        String columnName = "IS_TRUE";
        final ResultSet rs = (ResultSet)this.m.mock(ResultSet.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((ResultSet)this.one(rs)).getString("IS_TRUE");
                this.will(2.returnValue((Object)"N"));
                ((ResultSet)this.one(rs)).wasNull();
                this.will(2.returnValue((Object)false));
            }
        });
        Boolean b = (Boolean)type.nullSafeGet(rs, "IS_TRUE", this.sessionImplementor);
        Assert.assertNotNull((Object)b);
        Assert.assertFalse((boolean)b);
        this.m.assertIsSatisfied();
    }

    @Test
    public void getNullReturnsFalse() throws Exception {
        YesNoNullableBooleanType type = YesNoNullableBooleanType.INSTANCE;
        String columnName = "IS_TRUE";
        final ResultSet rs = (ResultSet)this.m.mock(ResultSet.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((ResultSet)this.one(rs)).getString("IS_TRUE");
                this.will(3.returnValue(null));
            }
        });
        Boolean b = (Boolean)type.nullSafeGet(rs, "IS_TRUE", this.sessionImplementor);
        Assert.assertNotNull((Object)b);
        Assert.assertFalse((boolean)b);
        this.m.assertIsSatisfied();
    }

    @Test
    public void setTrueReturnsY() throws Exception {
        YesNoNullableBooleanType type = YesNoNullableBooleanType.INSTANCE;
        final PreparedStatement st = (PreparedStatement)this.m.mock(PreparedStatement.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((PreparedStatement)this.one(st)).setString(0, "Y");
            }
        });
        type.nullSafeSet(st, (Object)true, 0, this.sessionImplementor);
        this.m.assertIsSatisfied();
    }

    @Test
    public void setFalseReturnsN() throws Exception {
        YesNoNullableBooleanType type = YesNoNullableBooleanType.INSTANCE;
        final PreparedStatement st = (PreparedStatement)this.m.mock(PreparedStatement.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((PreparedStatement)this.one(st)).setString(0, "N");
            }
        });
        type.nullSafeSet(st, (Object)false, 0, this.sessionImplementor);
        this.m.assertIsSatisfied();
    }

    @Test
    public void setNullReturnsNull() throws Exception {
        YesNoNullableBooleanType type = YesNoNullableBooleanType.INSTANCE;
        final PreparedStatement st = (PreparedStatement)this.m.mock(PreparedStatement.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((PreparedStatement)this.one(st)).setNull(0, 12);
            }
        });
        type.nullSafeSet(st, null, 0, this.sessionImplementor);
        this.m.assertIsSatisfied();
    }

    @Test
    public void trueIsCopied() throws Exception {
        YesNoNullableBooleanType type = YesNoNullableBooleanType.INSTANCE;
        boolean b = true;
        Boolean copy = (Boolean)type.deepCopy((Object)b);
        Assert.assertNotNull((Object)copy);
        Assert.assertEquals((Object)b, (Object)copy);
        Assert.assertTrue((boolean)copy);
    }

    @Test
    public void falseIsCopied() throws Exception {
        YesNoNullableBooleanType type = YesNoNullableBooleanType.INSTANCE;
        boolean b = false;
        Boolean copy = (Boolean)type.deepCopy((Object)b);
        Assert.assertNotNull((Object)copy);
        Assert.assertEquals((Object)b, (Object)copy);
        Assert.assertFalse((boolean)copy);
    }

    @Test
    public void nullIsCopied() throws Exception {
        YesNoNullableBooleanType type = YesNoNullableBooleanType.INSTANCE;
        Object b = null;
        Boolean copy = (Boolean)type.deepCopy(b);
        Assert.assertNull((Object)copy);
    }

    @Test
    public void equals() throws Exception {
        YesNoNullableBooleanType type = YesNoNullableBooleanType.INSTANCE;
        Assert.assertTrue((boolean)type.equals((Object)true, (Object)true));
        Assert.assertTrue((boolean)type.equals((Object)false, (Object)false));
        Assert.assertFalse((boolean)type.equals((Object)false, (Object)true));
        Assert.assertFalse((boolean)type.equals((Object)true, (Object)false));
    }

    @Test
    public void equalsWithNulls() throws Exception {
        YesNoNullableBooleanType type = YesNoNullableBooleanType.INSTANCE;
        Assert.assertFalse((boolean)type.equals((Object)true, null));
        Assert.assertFalse((boolean)type.equals(null, (Object)true));
        Assert.assertFalse((boolean)type.equals((Object)false, null));
        Assert.assertFalse((boolean)type.equals(null, (Object)false));
        Assert.assertTrue((boolean)type.equals(null, null));
    }
}

