package uk.ac.warwick.util.hibernate4;


import org.hamcrest.Description;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.api.Action;
import org.jmock.api.Invocation;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Before;

/**
 * Base for user type tests. Constructs a mock SessionImplementor that does
 * just enough. You can tell JMock to make the mock return further mocks, but
 * then the ValueBinder and ValueExtractor objects are mocks that do nothing,
 * so we need to pop in a real Dialect so that it actually does work.
 *
 * It doesn't really matter what the Dialect is but I chose HSQLDialect.
 */
public abstract class UserTypeTestBase {

    protected final Mockery m = new JUnit4Mockery();
    protected final SharedSessionContractImplementor sessionImplementor = m.mock(SharedSessionContractImplementor.class);

    private final SessionFactoryImplementor factory = m.mock(SessionFactoryImplementor.class);

    @Before
    public void setup() {
        m.checking(new Expectations(){{
            allowing(sessionImplementor).getFactory(); will(returnValue(factory));
            allowing(factory).getDialect(); will(returnValue(new HSQLDialect()));
            allowing(sessionImplementor).remapSqlTypeDescriptor(with(aNonNull(SqlTypeDescriptor.class))); will(new Action() {
                @Override
                public void describeTo(Description description) {
                    description.appendText("returns the argument");
                }

                @Override
                public Object invoke(Invocation invocation) throws Throwable {
                    return invocation.getParameter(0);
                }
            });
            ignoring(sessionImplementor);
            ignoring(factory);
        }});
    }

}
