/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.io.ByteSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import uk.ac.warwick.util.files.FileReferenceCreationStrategy;
import uk.ac.warwick.util.files.HashFileReference;
import uk.ac.warwick.util.files.LocalFileReference;
import uk.ac.warwick.util.files.Storeable;
import uk.ac.warwick.util.files.hash.FileHashResolver;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.impl.AbstractFileStore;
import uk.ac.warwick.util.files.impl.FileBackedLocalFileReference;

public final class LocalFilesystemFileStore
extends AbstractFileStore
implements InitializingBean {
    public LocalFilesystemFileStore(Map<String, FileHashResolver> resolvers, FileReferenceCreationStrategy strategy) {
        super(resolvers, strategy);
    }

    @Override
    protected HashFileReference doStore(ByteSource in, HashString hash, HashFileReference target) throws IOException {
        if (!target.isFileBacked()) {
            throw new UnsupportedOperationException("Storage to non-file backed data not implemented");
        }
        File outputFile = new File(target.getFileLocation().getPath());
        if (outputFile.exists()) {
            throw new IllegalArgumentException("Output file already exists for " + outputFile);
        }
        if (!(outputFile.getParentFile().exists() && outputFile.getParentFile().isDirectory() || outputFile.getParentFile().mkdirs())) {
            throw new IllegalStateException("Could not create parent directory for " + outputFile);
        }
        this.statistics.time(() -> {
            try (FileOutputStream os = new FileOutputStream(outputFile);){
                in.copyTo((OutputStream)os);
            }
        }, this.statistics::referenceWritten);
        return target;
    }

    private File resolve(Storeable storeable) {
        return this.resolve(storeable.getStrategy(), storeable.getPath());
    }

    private File resolve(Storeable.StorageStrategy storageStrategy, String path) {
        File rootDirectory = new File(storageStrategy.getRootPath());
        Assert.notNull((Object)rootDirectory);
        return new File(rootDirectory, path);
    }

    @Override
    public LocalFileReference getForPath(Storeable.StorageStrategy storageStrategy, String path) {
        File newFile = this.resolve(storageStrategy, path);
        return new FileBackedLocalFileReference(this, newFile, path, storageStrategy);
    }

    @Override
    public Stream<String> list(Storeable.StorageStrategy storageStrategy, String basePath) {
        return this.statistics.timeSafe(() -> {
            File dir = this.resolve(storageStrategy, basePath);
            String[] fileNames = dir.list();
            if (fileNames == null) {
                return Stream.empty();
            }
            return Stream.of(fileNames);
        }, this.statistics::traversed);
    }

    @Override
    public LocalFileReference storeLocalReference(Storeable storeable, ByteSource in) throws IOException {
        File target = this.resolve(storeable);
        return this.doStore(storeable, in.openBufferedStream(), target);
    }

    @Override
    public LocalFileReference copy(LocalFileReference ref, Storeable targetStoreable) throws IOException {
        File target = this.resolve(targetStoreable);
        File source = new File(ref.getFileLocation().getPath());
        return this.doStore(targetStoreable, new FileInputStream(source), target);
    }

    @Override
    public LocalFileReference rename(LocalFileReference ref, Storeable targetStoreable) throws IOException {
        File target = this.resolve(targetStoreable);
        File source = new File(ref.getFileLocation().getPath());
        if (!target.getParentFile().exists()) {
            Assert.isTrue((boolean)target.getParentFile().mkdirs(), (String)("Couldn't create dirs for " + target));
        }
        if (!source.renameTo(target)) {
            throw new IOException("Could not rename " + source + " to " + target);
        }
        return new FileBackedLocalFileReference(this, target, targetStoreable.getPath(), ref.getStorageStrategy());
    }

    private LocalFileReference doStore(Storeable storeable, InputStream in, File target) throws IOException {
        if (target.exists()) {
            throw new IllegalArgumentException("Path " + target + " already exists");
        }
        if (!target.getParentFile().exists()) {
            Assert.isTrue((boolean)target.getParentFile().mkdirs(), (String)("Couldn't create dirs for " + target));
        }
        this.statistics.time(() -> FileCopyUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(target)), this.statistics::referenceWritten);
        return new FileBackedLocalFileReference(this, target, storeable.getPath(), storeable.getStrategy());
    }
}

