/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.net.URI;
import uk.ac.warwick.util.files.FileData;
import uk.ac.warwick.util.files.FileReference;
import uk.ac.warwick.util.files.HashFileReference;
import uk.ac.warwick.util.files.HashFileStore;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.impl.AbstractFileReference;

public final class EmptyHashBackedFileReference
extends AbstractFileReference
implements HashFileReference {
    private final HashFileStore fileStore;
    private final String storeName;
    private final Data data = new Data();

    public EmptyHashBackedFileReference(HashFileStore store, String theStoreName) {
        this.fileStore = store;
        this.storeName = theStoreName;
    }

    @Override
    public HashString getHash() {
        return null;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public HashFileReference copyTo(FileReference target) throws IOException {
        return new EmptyHashBackedFileReference(this.fileStore, this.storeName);
    }

    @Override
    public HashFileReference renameTo(FileReference target) throws IOException {
        return this;
    }

    @Override
    public FileData<FileReference> getData() {
        return this.data;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public void unlink() {
    }

    class Data
    implements FileData {
        Data() {
        }

        @Override
        public boolean delete() {
            return true;
        }

        public HashFileReference overwrite(ByteSource in) throws IOException {
            return EmptyHashBackedFileReference.this.fileStore.createHashReference(in, EmptyHashBackedFileReference.this.storeName);
        }

        @Override
        public ByteSource asByteSource() {
            return ByteSource.empty();
        }

        @Override
        public long length() {
            return 0L;
        }

        @Override
        public URI getFileLocation() {
            throw new UnsupportedOperationException("This file reference doesn't exist");
        }

        @Override
        public boolean isExists() {
            return false;
        }

        @Override
        public boolean isFileBacked() {
            return false;
        }
    }
}

