/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.annotations.Beta;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.domain.Location;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;
import uk.ac.warwick.util.files.impl.RenameMode;

public class ContainerRenamingBlobStore
implements BlobStore {
    private final BlobStoreContext context;
    private final RenameMode mode;
    private final BlobStore delegate;

    public BlobStoreContext getContext() {
        return this.delegate.getContext();
    }

    public BlobBuilder blobBuilder(String name) {
        return this.delegate.blobBuilder(name);
    }

    public Set<? extends Location> listAssignableLocations() {
        return this.delegate.listAssignableLocations();
    }

    public PageSet<? extends StorageMetadata> list() {
        return this.delegate.list();
    }

    public boolean containerExists(String container) {
        return this.delegate.containerExists(this.rename(container));
    }

    public boolean createContainerInLocation(Location location, String container) {
        return this.delegate.createContainerInLocation(location, this.rename(container));
    }

    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        return this.delegate.createContainerInLocation(location, this.rename(container), options);
    }

    @Beta
    public ContainerAccess getContainerAccess(String container) {
        return this.delegate.getContainerAccess(this.rename(container));
    }

    @Beta
    public void setContainerAccess(String container, ContainerAccess access) {
        this.delegate.setContainerAccess(this.rename(container), access);
    }

    public PageSet<? extends StorageMetadata> list(String container) {
        return this.delegate.list(this.rename(container));
    }

    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        return this.delegate.list(this.rename(container), options);
    }

    public void clearContainer(String container) {
        this.delegate.clearContainer(this.rename(container));
    }

    public void clearContainer(String container, ListContainerOptions options) {
        this.delegate.clearContainer(this.rename(container), options);
    }

    public void deleteContainer(String container) {
        this.delegate.deleteContainer(this.rename(container));
    }

    public boolean deleteContainerIfEmpty(String container) {
        return this.delegate.deleteContainerIfEmpty(this.rename(container));
    }

    @Deprecated
    public boolean directoryExists(String container, String directory) {
        return this.delegate.directoryExists(this.rename(container), directory);
    }

    @Deprecated
    public void createDirectory(String container, String directory) {
        this.delegate.createDirectory(this.rename(container), directory);
    }

    @Deprecated
    public void deleteDirectory(String containerName, String name) {
        this.delegate.deleteDirectory(containerName, name);
    }

    public boolean blobExists(String container, String name) {
        return this.delegate.blobExists(this.rename(container), name);
    }

    public String putBlob(String container, Blob blob) {
        return this.delegate.putBlob(this.rename(container), blob);
    }

    public String putBlob(String container, Blob blob, PutOptions options) {
        return this.delegate.putBlob(this.rename(container), blob, options);
    }

    @Beta
    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        return this.delegate.copyBlob(this.rename(fromContainer), fromName, this.rename(toContainer), toName, options);
    }

    @Nullable
    public BlobMetadata blobMetadata(String container, String name) {
        return this.delegate.blobMetadata(this.rename(container), name);
    }

    @Nullable
    public Blob getBlob(String container, String name) {
        return this.delegate.getBlob(this.rename(container), name);
    }

    @Nullable
    public Blob getBlob(String container, String name, GetOptions options) {
        return this.delegate.getBlob(this.rename(container), name, options);
    }

    public void removeBlob(String container, String name) {
        this.delegate.removeBlob(this.rename(container), name);
    }

    public void removeBlobs(String container, Iterable<String> names) {
        this.delegate.removeBlobs(this.rename(container), names);
    }

    @Beta
    public BlobAccess getBlobAccess(String container, String name) {
        return this.delegate.getBlobAccess(this.rename(container), name);
    }

    @Beta
    public void setBlobAccess(String container, String name, BlobAccess access) {
        this.delegate.setBlobAccess(this.rename(container), name, access);
    }

    public long countBlobs(String container) {
        return this.delegate.countBlobs(this.rename(container));
    }

    public long countBlobs(String container, ListContainerOptions options) {
        return this.delegate.countBlobs(this.rename(container), options);
    }

    @Beta
    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blob, PutOptions options) {
        return this.delegate.initiateMultipartUpload(this.rename(container), blob, options);
    }

    @Beta
    public void abortMultipartUpload(MultipartUpload mpu) {
        this.delegate.abortMultipartUpload(mpu);
    }

    @Beta
    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        return this.delegate.completeMultipartUpload(mpu, parts);
    }

    @Beta
    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        return this.delegate.uploadMultipartPart(mpu, partNumber, payload);
    }

    @Beta
    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        return this.delegate.listMultipartUpload(mpu);
    }

    @Beta
    public List<MultipartUpload> listMultipartUploads(String container) {
        return this.delegate.listMultipartUploads(this.rename(container));
    }

    @Beta
    public long getMinimumMultipartPartSize() {
        return this.delegate.getMinimumMultipartPartSize();
    }

    @Beta
    public long getMaximumMultipartPartSize() {
        return this.delegate.getMaximumMultipartPartSize();
    }

    @Beta
    public int getMaximumNumberOfParts() {
        return this.delegate.getMaximumNumberOfParts();
    }

    @Beta
    public void downloadBlob(String container, String name, File destination) {
        this.delegate.downloadBlob(this.rename(container), name, destination);
    }

    @Beta
    public void downloadBlob(String container, String name, File destination, ExecutorService executor) {
        this.delegate.downloadBlob(this.rename(container), name, destination, executor);
    }

    @Beta
    public InputStream streamBlob(String container, String name) {
        return this.delegate.streamBlob(this.rename(container), name);
    }

    @Beta
    public InputStream streamBlob(String container, String name, ExecutorService executor) {
        return this.delegate.streamBlob(this.rename(container), name, executor);
    }

    public ContainerRenamingBlobStore(BlobStoreContext context, BlobStore blobStore, RenameMode mode) {
        this.delegate = blobStore;
        this.context = context;
        this.mode = mode;
    }

    private String rename(String containerName) {
        return this.mode.rename(containerName);
    }
}

