/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.io.ByteSource;
import java.io.IOException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jclouds.blobstore.domain.Blob;
import uk.ac.warwick.util.files.FileData;
import uk.ac.warwick.util.files.FileReference;
import uk.ac.warwick.util.files.HashFileReference;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.impl.AbstractBlobBackedFileData;
import uk.ac.warwick.util.files.impl.AbstractFileReference;
import uk.ac.warwick.util.files.impl.BlobBackedHashFileReference;

public class CachingBlobBackedHashFileReference
extends AbstractFileReference
implements HashFileReference {
    private final BlobBackedHashFileReference delegate;
    private final LoadingCache<String, Blob> cache;

    public CachingBlobBackedHashFileReference(BlobBackedHashFileReference delegate, LoadingCache<String, Blob> cache) {
        this.delegate = delegate;
        this.cache = cache;
    }

    @Override
    public FileData<FileReference> getData() {
        return new CachedData(this.delegate.getData());
    }

    @Override
    public String getPath() {
        return this.delegate.getPath();
    }

    @Override
    public HashString getHash() {
        return this.delegate.getHash();
    }

    @Override
    public boolean isLocal() {
        return this.delegate.isLocal();
    }

    @Override
    public void unlink() {
    }

    @Override
    public FileReference copyTo(FileReference target) {
        return new CachingBlobBackedHashFileReference(this.delegate.copyTo(target), this.cache);
    }

    @Override
    public FileReference renameTo(FileReference target) {
        return new CachingBlobBackedHashFileReference(this.delegate.renameTo(target), this.cache);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("delegate", (Object)this.delegate).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachingBlobBackedHashFileReference that = (CachingBlobBackedHashFileReference)o;
        return new EqualsBuilder().append((Object)this.delegate, (Object)that.delegate).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.delegate).toHashCode();
    }

    class CachedData
    extends AbstractBlobBackedFileData {
        private final BlobBackedHashFileReference.Data delegate;

        private CachedData(BlobBackedHashFileReference.Data data) {
            super(data.getStatistics(), data.getBlobStore(), data.getContainerName(), data.getBlobName());
            this.delegate = data;
        }

        public HashFileReference overwrite(ByteSource in) throws IOException {
            return this.delegate.overwrite(in);
        }

        @Override
        public AbstractBlobBackedFileData.BlobBackedByteSource asByteSource() {
            return new CachedBlobBackedByteSource();
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException("Can't delete FileData from CachingBlobBackedHashFileReference");
        }

        private class CachedBlobBackedByteSource
        extends AbstractBlobBackedFileData.BlobBackedByteSource {
            private CachedBlobBackedByteSource() {
            }

            @Override
            synchronized void refresh() {
                this.blob = (Blob)CachingBlobBackedHashFileReference.this.cache.get((Object)CachedData.this.getBlobName());
                this.totalLength = this.blob == null ? -1L : this.blob.getMetadata().getSize();
                this.payloadUsed = false;
            }

            @Override
            public String toString() {
                return "CachingBlobBackedHashFileReference.asByteSource(" + super.toString() + ")";
            }
        }
    }
}

