/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.io.ByteSource;
import java.io.IOException;
import org.jclouds.blobstore.BlobStore;
import uk.ac.warwick.util.files.FileReference;
import uk.ac.warwick.util.files.HashFileReference;
import uk.ac.warwick.util.files.HashFileStore;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.impl.AbstractBlobBackedFileData;
import uk.ac.warwick.util.files.impl.AbstractFileReference;

public final class BlobBackedHashFileReference
extends AbstractFileReference
implements HashFileReference {
    private final HashFileStore fileStore;
    private final BlobStore blobStore;
    private final String containerName;
    private HashString hash;
    private transient Data data;

    public BlobBackedHashFileReference(HashFileStore store, BlobStore blobStore, String containerName, HashString theHash) {
        this.fileStore = store;
        this.blobStore = blobStore;
        this.containerName = containerName;
        this.update(theHash);
    }

    @Override
    public HashString getHash() {
        return this.hash;
    }

    @Override
    public String getPath() {
        return null;
    }

    private void update(HashString theHash) {
        this.hash = theHash;
        this.data = new Data();
    }

    @Override
    public BlobBackedHashFileReference copyTo(FileReference target) {
        return new BlobBackedHashFileReference(this.fileStore, this.blobStore, this.containerName, this.hash);
    }

    @Override
    public BlobBackedHashFileReference renameTo(FileReference target) {
        return this;
    }

    public Data getData() {
        return this.data;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.hash + " (" + this.data.toString() + ")";
    }

    @Override
    public void unlink() {
    }

    class Data
    extends AbstractBlobBackedFileData {
        private Data() {
            super(BlobBackedHashFileReference.this.fileStore, BlobBackedHashFileReference.this.blobStore, BlobBackedHashFileReference.this.containerName, BlobBackedHashFileReference.this.hash.getHash());
        }

        public HashFileReference overwrite(ByteSource in) throws IOException {
            HashFileReference newReference = BlobBackedHashFileReference.this.fileStore.createHashReference(in, BlobBackedHashFileReference.this.getHash().getStoreName());
            BlobBackedHashFileReference.this.update(newReference.getHash());
            return newReference;
        }
    }
}

